/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.util;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiLoader {
    public OpenAPI loadApi(@Nonnull OpenApiInteractionValidator.SpecSource specSource, @Nonnull List<AuthorizationValue> authData, @Nonnull ParseOptions parseOptions) {
        Objects.requireNonNull(specSource, "A spec source is required");
        Objects.requireNonNull(parseOptions, "Parse options are required");
        SwaggerParseResult parseResult = this.readSwaggerParserResult(specSource, authData, parseOptions);
        if (this.hasParseErrors(parseResult)) {
            throw new OpenApiInteractionValidator.ApiLoadException(specSource.getValue(), parseResult);
        }
        OpenAPI api = parseResult.getOpenAPI();
        OpenApiLoader.removeRegexPatternOnStringsOfFormatByte(api);
        OpenApiLoader.removeTypeObjectAssociationWithOneOfAndAnyOfModels(api);
        return api;
    }

    private boolean hasParseErrors(@Nullable SwaggerParseResult parseResult) {
        if (parseResult == null || parseResult.getOpenAPI() == null) {
            return true;
        }
        return parseResult.getMessages() != null && !parseResult.getMessages().isEmpty();
    }

    private SwaggerParseResult readSwaggerParserResult(OpenApiInteractionValidator.SpecSource specSource, List<AuthorizationValue> authData, ParseOptions parseOptions) {
        OpenAPIParser openAPIParser = new OpenAPIParser();
        try {
            if (specSource.isInlineSpecification()) {
                return openAPIParser.readContents(specSource.getValue(), authData, parseOptions);
            }
            if (specSource.isSpecUrl()) {
                return openAPIParser.readLocation(specSource.getValue(), authData, parseOptions);
            }
            SwaggerParseResult parseResult = openAPIParser.readLocation(specSource.getValue(), authData, parseOptions);
            if (parseResult != null && parseResult.getOpenAPI() != null) {
                return parseResult;
            }
            return openAPIParser.readContents(specSource.getValue(), authData, parseOptions);
        }
        catch (RuntimeException e) {
            throw new OpenApiInteractionValidator.ApiLoadException(specSource.getValue(), e);
        }
    }

    private static void removeTypeObjectAssociationWithOneOfAndAnyOfModels(@Nonnull OpenAPI openAPI) {
        if (openAPI.getComponents() != null) {
            OpenApiLoader.removeTypeObjectFromEachValue(openAPI.getComponents().getSchemas(), schema -> schema);
        }
    }

    private static <T> void removeTypeObjectFromEachValue(Map<String, T> map, Function<T, Object> function) {
        if (map != null) {
            map.values().forEach(it -> OpenApiLoader.removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(function.apply(it)));
        }
    }

    private static void removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(@Nonnull Object object) {
        if (object instanceof ObjectSchema) {
            OpenApiLoader.removeTypeObjectFromEachValue(((ObjectSchema)object).getProperties(), schema -> schema);
        } else if (object instanceof ArraySchema) {
            OpenApiLoader.removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(((ArraySchema)object).getItems());
        } else if (object instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)object;
            composedSchema.setType(null);
        }
    }

    private static void removeRegexPatternOnStringsOfFormatByte(@Nonnull OpenAPI openAPI) {
        if (openAPI.getPaths() != null) {
            openAPI.getPaths().values().forEach(pathItem -> pathItem.readOperations().forEach(operation -> {
                OpenApiLoader.excludeBase64PatternFromEachValue(operation.getResponses(), ApiResponse::getContent);
                if (operation.getRequestBody() != null) {
                    OpenApiLoader.excludeBase64PatternFromSchema(operation.getRequestBody().getContent());
                }
                if (operation.getParameters() != null) {
                    operation.getParameters().forEach(it -> OpenApiLoader.excludeBase64PatternFromSchema(it.getContent()));
                    operation.getParameters().forEach(it -> OpenApiLoader.excludeBase64PatternFromSchema(it.getSchema()));
                }
            }));
        }
        if (openAPI.getComponents() != null) {
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getResponses(), ApiResponse::getContent);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getRequestBodies(), RequestBody::getContent);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getHeaders(), Header::getContent);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getHeaders(), Header::getSchema);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getParameters(), Parameter::getContent);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getParameters(), Parameter::getSchema);
            OpenApiLoader.excludeBase64PatternFromEachValue(openAPI.getComponents().getSchemas(), schema -> schema);
        }
    }

    private static <T> void excludeBase64PatternFromEachValue(Map<String, T> map, Function<T, Object> function) {
        if (map != null) {
            map.values().forEach(it -> OpenApiLoader.excludeBase64PatternFromSchema(function.apply(it)));
        }
    }

    private static void excludeBase64PatternFromSchema(@Nonnull Object object) {
        StringSchema stringSchema;
        if (object instanceof Content) {
            OpenApiLoader.excludeBase64PatternFromEachValue((Content)object, MediaType::getSchema);
        } else if (object instanceof ObjectSchema) {
            OpenApiLoader.excludeBase64PatternFromEachValue(((ObjectSchema)object).getProperties(), schema -> schema);
        } else if (object instanceof ArraySchema) {
            OpenApiLoader.excludeBase64PatternFromSchema(((ArraySchema)object).getItems());
        } else if (object instanceof StringSchema && "byte".equals((stringSchema = (StringSchema)object).getFormat())) {
            stringSchema.setPattern(null);
        }
    }
}

