/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.slp.ServiceLocationAttribute;
import org.sblim.slp.internal.Convert;

public class AttributeHandler {
    public static String buildString(ServiceLocationAttribute pAttr) {
        StringBuffer buf = new StringBuffer();
        Vector valVec = pAttr.getValues();
        if (valVec != null && valVec.size() > 0) {
            buf.append('(');
        }
        buf.append(Convert.escape(pAttr.getId(), "(),\\!<=>~"));
        if (valVec != null && valVec.size() > 0) {
            buf.append('=');
            Iterator itr = valVec.iterator();
            boolean first = true;
            while (itr.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(AttributeHandler.escapeValue(itr.next()));
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public static String escapeValue(Object pValue) {
        if (pValue instanceof String) {
            return Convert.escape((String)pValue, "(),\\!<=>~");
        }
        if (pValue instanceof Integer) {
            return ((Integer)pValue).toString();
        }
        if (pValue instanceof Boolean) {
            return ((Boolean)pValue).toString();
        }
        if (pValue instanceof byte[]) {
            return AttributeHandler.mkOpaqueStr((byte[])pValue);
        }
        if (pValue == null) {
            return "";
        }
        throw new IllegalArgumentException("Type: " + pValue.getClass().getName() + " cannot be an attribute value!");
    }

    public static String mkOpaqueStr(byte[] pBytes) {
        StringBuffer buf = new StringBuffer("\\FF");
        for (int i = 0; i < pBytes.length; ++i) {
            int value = pBytes[i] & 0xFF;
            String hexStr = Integer.toString(value, 16);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
        }
        return buf.toString();
    }
}

