/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic.mapping;

import java.net.InetAddress;
import java.util.Optional;
import org.mapstruct.AfterMapping;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.opennms.core.cache.Cache;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.alarms.history.elastic.dto.AlarmDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.NodeDocumentDTO;
import org.opennms.features.alarms.history.elastic.mapping.DateMapper;
import org.opennms.features.alarms.history.elastic.mapping.EventMapper;
import org.opennms.features.alarms.history.elastic.mapping.MemoMapper;
import org.opennms.features.alarms.history.elastic.mapping.NodeMapper;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.TroubleTicketState;

@Mapper(uses={EventMapper.class, MemoMapper.class, DateMapper.class})
public interface AlarmMapper {
    @Mappings(value={@Mapping(source="TTicketId", target="ticketId"), @Mapping(source="TTicketState", target="ticketStateId"), @Mapping(source="TTicketState", target="ticketStateName"), @Mapping(source="alarmType", target="type"), @Mapping(source="details", target="attributes"), @Mapping(source="ipAddr", target="ipAddress"), @Mapping(source="logMsg", target="logMessage"), @Mapping(source="operInstruct", target="operatorInstructions"), @Mapping(source="reductionKeyMemo", target="journalMemo"), @Mapping(ignore=true, target="node")})
    public AlarmDocumentDTO map(OnmsAlarm var1, @Context MappingContext var2);

    default public String mapIpAddressToString(InetAddress ipAddress) {
        return ipAddress == null ? null : InetAddressUtils.str((InetAddress)ipAddress);
    }

    default public String mapServiceTypeToString(OnmsServiceType serviceType) {
        return serviceType == null ? null : serviceType.getName();
    }

    default public Integer mapTroubleTicketStateToInteger(TroubleTicketState troubleTicketState) {
        return troubleTicketState == null ? null : Integer.valueOf(troubleTicketState.getValue());
    }

    default public String mapTroubleTicketStateToString(TroubleTicketState troubleTicketState) {
        return troubleTicketState == null ? null : troubleTicketState.toString();
    }

    @AfterMapping
    default public void afterMapping(OnmsAlarm alarm, @MappingTarget AlarmDocumentDTO alarmDocumentDTO, @Context MappingContext mappingContext) {
        if (alarm.getNodeId() != null) {
            Optional cachedNodeDoc = (Optional)mappingContext.getNodeInfoCache().getIfCached((Object)alarm.getNodeId());
            if (cachedNodeDoc != null && cachedNodeDoc.isPresent()) {
                alarmDocumentDTO.setNode((NodeDocumentDTO)cachedNodeDoc.get());
            } else {
                NodeDocumentDTO nodeDoc = ((NodeMapper)Mappers.getMapper(NodeMapper.class)).map(alarm.getNode());
                mappingContext.getNodeInfoCache().put((Object)alarm.getNodeId(), Optional.of(nodeDoc));
                alarmDocumentDTO.setNode(nodeDoc);
            }
        }
        alarmDocumentDTO.setUpdateTime(mappingContext.getCurrentTime());
    }

    public static interface MappingContext {
        public Cache<Integer, Optional<NodeDocumentDTO>> getNodeInfoCache();

        public long getCurrentTime();
    }
}

