/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.com.squareup.moshi;

import io.pyroscope.com.squareup.moshi.internal.Util;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class ClassFactory<T> {
    ClassFactory() {
    }

    abstract T newInstance() throws InvocationTargetException, IllegalAccessException, InstantiationException;

    public static <T> ClassFactory<T> get(final Class<?> rawType) {
        try {
            final Constructor<?> constructor = rawType.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return new ClassFactory<T>(){

                @Override
                public T newInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    Object[] args2 = null;
                    return constructor.newInstance(args2);
                }

                public String toString() {
                    return rawType.getName();
                }
            };
        }
        catch (NoSuchMethodException constructor) {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field f = unsafeClass.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                final Object unsafe = f.get(null);
                final Method allocateInstance = unsafeClass.getMethod("allocateInstance", Class.class);
                return new ClassFactory<T>(){

                    @Override
                    public T newInstance() throws InvocationTargetException, IllegalAccessException {
                        return allocateInstance.invoke(unsafe, rawType);
                    }

                    public String toString() {
                        return rawType.getName();
                    }
                };
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                try {
                    Method getConstructorId = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                    getConstructorId.setAccessible(true);
                    final int constructorId = (Integer)getConstructorId.invoke(null, Object.class);
                    final Method newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                    newInstance.setAccessible(true);
                    return new ClassFactory<T>(){

                        @Override
                        public T newInstance() throws InvocationTargetException, IllegalAccessException {
                            return newInstance.invoke(null, rawType, constructorId);
                        }

                        public String toString() {
                            return rawType.getName();
                        }
                    };
                }
                catch (IllegalAccessException e2) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e3) {
                    throw Util.rethrowCause(e3);
                }
                catch (NoSuchMethodException e3) {
                    try {
                        final Method newInstance = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                        newInstance.setAccessible(true);
                        return new ClassFactory<T>(){

                            @Override
                            public T newInstance() throws InvocationTargetException, IllegalAccessException {
                                return newInstance.invoke(null, rawType, Object.class);
                            }

                            public String toString() {
                                return rawType.getName();
                            }
                        };
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("cannot construct instances of " + rawType.getName());
                    }
                }
            }
        }
    }
}

