/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf.codec.wmf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.opennms.shaded.jasper.com.lowagie.text.Document;
import org.opennms.shaded.jasper.com.lowagie.text.ExceptionConverter;
import org.opennms.shaded.jasper.com.lowagie.text.Font;
import org.opennms.shaded.jasper.com.lowagie.text.FontFactory;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.BaseFont;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.codec.wmf.InputMeta;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.codec.wmf.MetaObject;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.codec.wmf.MetaState;

public class MetaFont
extends MetaObject {
    static final String[] fontNames = new String[]{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Symbol", "ZapfDingbats"};
    static final int MARKER_BOLD = 1;
    static final int MARKER_ITALIC = 2;
    static final int MARKER_COURIER = 0;
    static final int MARKER_HELVETICA = 4;
    static final int MARKER_TIMES = 8;
    static final int MARKER_SYMBOL = 12;
    static final int DEFAULT_PITCH = 0;
    static final int FIXED_PITCH = 1;
    static final int VARIABLE_PITCH = 2;
    static final int FF_DONTCARE = 0;
    static final int FF_ROMAN = 1;
    static final int FF_SWISS = 2;
    static final int FF_MODERN = 3;
    static final int FF_SCRIPT = 4;
    static final int FF_DECORATIVE = 5;
    static final int BOLDTHRESHOLD = 600;
    static final int nameSize = 32;
    static final int ETO_OPAQUE = 2;
    static final int ETO_CLIPPED = 4;
    int height;
    float angle;
    int bold;
    int italic;
    boolean underline;
    boolean strikeout;
    int charset;
    int pitchAndFamily;
    String faceName = "arial";
    BaseFont font = null;

    public MetaFont() {
        this.type = 3;
    }

    public void init(InputMeta inputMeta) throws IOException {
        int n;
        int n2;
        this.height = Math.abs(inputMeta.readShort());
        inputMeta.skip(2);
        this.angle = (float)((double)inputMeta.readShort() / 1800.0 * Math.PI);
        inputMeta.skip(2);
        this.bold = inputMeta.readShort() >= 600 ? 1 : 0;
        this.italic = inputMeta.readByte() != 0 ? 2 : 0;
        this.underline = inputMeta.readByte() != 0;
        this.strikeout = inputMeta.readByte() != 0;
        this.charset = inputMeta.readByte();
        inputMeta.skip(3);
        this.pitchAndFamily = inputMeta.readByte();
        byte[] byArray = new byte[32];
        for (n2 = 0; n2 < 32 && (n = inputMeta.readByte()) != 0; ++n2) {
            byArray[n2] = (byte)n;
        }
        try {
            this.faceName = new String(byArray, 0, n2, "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.faceName = new String(byArray, 0, n2);
        }
        this.faceName = this.faceName.toLowerCase();
    }

    public BaseFont getFont() {
        String string;
        if (this.font != null) {
            return this.font;
        }
        Font font = FontFactory.getFont(this.faceName, "Cp1252", true, 10.0f, (this.italic != 0 ? 2 : 0) | (this.bold != 0 ? 1 : 0));
        this.font = font.getBaseFont();
        if (this.font != null) {
            return this.font;
        }
        if (this.faceName.indexOf("courier") != -1 || this.faceName.indexOf("terminal") != -1 || this.faceName.indexOf("fixedsys") != -1) {
            string = fontNames[0 + this.italic + this.bold];
        } else if (this.faceName.indexOf("ms sans serif") != -1 || this.faceName.indexOf("arial") != -1 || this.faceName.indexOf("system") != -1) {
            string = fontNames[4 + this.italic + this.bold];
        } else if (this.faceName.indexOf("arial black") != -1) {
            string = fontNames[4 + this.italic + 1];
        } else if (this.faceName.indexOf("times") != -1 || this.faceName.indexOf("ms serif") != -1 || this.faceName.indexOf("roman") != -1) {
            string = fontNames[8 + this.italic + this.bold];
        } else if (this.faceName.indexOf("symbol") != -1) {
            string = fontNames[12];
        } else {
            int n = this.pitchAndFamily & 3;
            int n2 = this.pitchAndFamily >> 4 & 7;
            block1 : switch (n2) {
                case 3: {
                    string = fontNames[0 + this.italic + this.bold];
                    break;
                }
                case 1: {
                    string = fontNames[8 + this.italic + this.bold];
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = fontNames[4 + this.italic + this.bold];
                    break;
                }
                default: {
                    switch (n) {
                        case 1: {
                            string = fontNames[0 + this.italic + this.bold];
                            break block1;
                        }
                    }
                    string = fontNames[4 + this.italic + this.bold];
                }
            }
        }
        try {
            this.font = BaseFont.createFont(string, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return this.font;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public float getFontSize(MetaState metaState) {
        return Math.abs(metaState.transformY(this.height) - metaState.transformY(0)) * Document.wmfFontCorrection;
    }
}

