/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.scv;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.integration.api.v1.scv.immutables.ImmutableCredentials;

public class SecureCredentialsVaultImpl
implements org.opennms.integration.api.v1.scv.SecureCredentialsVault {
    static final String OIA_PREFIX = "_oia_";
    private final SecureCredentialsVault delegate;

    public SecureCredentialsVaultImpl(SecureCredentialsVault delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Set<String> getAliases() {
        return this.delegate.getAliases().stream().filter(s -> s.startsWith(OIA_PREFIX)).map(s -> s.substring(OIA_PREFIX.length())).collect(Collectors.toSet());
    }

    public org.opennms.integration.api.v1.scv.Credentials getCredentials(String alias) {
        Objects.requireNonNull(alias);
        return Optional.ofNullable(this.delegate.getCredentials(OIA_PREFIX + alias.toLowerCase())).map(c -> new ImmutableCredentials(c.getUsername(), c.getPassword(), c.getAttributes())).orElse(null);
    }

    public void setCredentials(String alias, org.opennms.integration.api.v1.scv.Credentials credentials) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(credentials);
        this.delegate.setCredentials(OIA_PREFIX + alias.toLowerCase(), new Credentials(credentials.getUsername(), credentials.getPassword(), credentials.getAttributes()));
    }

    public void deleteCredentials(String alias) {
        Objects.requireNonNull(alias);
        this.delegate.deleteCredentials(OIA_PREFIX + alias.toLowerCase());
    }
}

