/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Collection;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.PreviewClickListener;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewConfigurationWindow;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewsConfigUI;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewsConfigList
extends VerticalLayout {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewsConfigList.class);
    private Table m_table;
    BeanItemContainer<View> m_beanItemContainer = new BeanItemContainer(View.class);
    private SurveillanceViewService m_surveillanceViewService;

    public SurveillanceViewsConfigList(SurveillanceViewService surveillanceViewService) {
        this.m_surveillanceViewService = surveillanceViewService;
        this.reloadSurveillanceViews();
        this.setSizeFull();
        this.setMargin(true);
        this.setSpacing(true);
        Label label = new Label("Surveillance View Configurations");
        label.addStyleName("configuration-title");
        Button addButton = new Button("Add");
        addButton.setStyleName("small");
        addButton.setDescription("Add surveillance view configuration");
        addButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                String newName;
                int i = 0;
                do {
                    newName = "Untitled #" + ++i;
                } while (SurveillanceViewProvider.getInstance().containsView(newName));
                View view = new View();
                view.setName(newName);
                SurveillanceViewsConfigList.this.getUI().addWindow((Window)new SurveillanceViewConfigurationWindow(SurveillanceViewsConfigList.this.m_surveillanceViewService, view, new SurveillanceViewConfigurationWindow.SaveActionListener(){

                    @Override
                    public void save(View view) {
                        SurveillanceViewsConfigList.this.m_beanItemContainer.addItem((Object)view);
                        SurveillanceViewProvider.getInstance().getSurveillanceViewConfiguration().getViews().add(view);
                        SurveillanceViewProvider.getInstance().save();
                        ((SurveillanceViewsConfigUI)SurveillanceViewsConfigList.this.getUI()).notifyMessage("Data saved", "Surveillance View");
                        SurveillanceViewsConfigList.this.m_table.refreshRowCache();
                        SurveillanceViewsConfigList.this.m_table.sort(new Object[]{"name"}, new boolean[]{true});
                    }
                }));
            }
        });
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.addComponent((Component)label);
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        horizontalLayout.setComponentAlignment((Component)label, Alignment.MIDDLE_LEFT);
        this.addComponent((Component)horizontalLayout);
        this.addComponent((Component)addButton);
        this.m_table = new Table();
        this.m_table.setContainerDataSource(this.m_beanItemContainer);
        this.m_table.setSizeFull();
        this.m_table.sort(new Object[]{"name"}, new boolean[]{true});
        this.m_table.addGeneratedColumn((Object)"Edit", new Table.ColumnGenerator(){

            public Object generateCell(Table source, final Object itemId, Object columnId) {
                Button button = new Button("Edit");
                button.setDescription("Edit this Surveillance View configuration");
                button.setStyleName("small");
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        SurveillanceViewsConfigList.this.getUI().addWindow((Window)new SurveillanceViewConfigurationWindow(SurveillanceViewsConfigList.this.m_surveillanceViewService, (View)SurveillanceViewsConfigList.this.m_beanItemContainer.getItem(itemId).getBean(), new SurveillanceViewConfigurationWindow.SaveActionListener(){

                            @Override
                            public void save(View view) {
                                View oldView = (View)SurveillanceViewsConfigList.this.m_beanItemContainer.getItem(itemId).getBean();
                                SurveillanceViewsConfigList.this.m_beanItemContainer.removeItem(itemId);
                                SurveillanceViewsConfigList.this.m_beanItemContainer.addItem((Object)view);
                                SurveillanceViewProvider.getInstance().replaceView(oldView, view);
                                SurveillanceViewProvider.getInstance().save();
                                ((SurveillanceViewsConfigUI)SurveillanceViewsConfigList.this.getUI()).notifyMessage("Data saved", "Surveillance view");
                                SurveillanceViewsConfigList.this.m_table.refreshRowCache();
                                SurveillanceViewsConfigList.this.m_table.sort(new Object[]{"name"}, new boolean[]{true});
                            }
                        }));
                    }
                });
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Remove", new Table.ColumnGenerator(){

            public Object generateCell(Table source, final Object itemId, Object columnId) {
                Button button = new Button("Remove");
                button.setDescription("Delete this Surveillance View configuration");
                button.setStyleName("small");
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        SurveillanceViewProvider.getInstance().removeView((View)itemId);
                        SurveillanceViewsConfigList.this.m_beanItemContainer.removeItem(itemId);
                    }
                });
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Preview", new Table.ColumnGenerator(){

            public Object generateCell(Table source, Object itemId, Object columnId) {
                Button button = new Button("Preview");
                button.setDescription("Preview this Surveillance View configuration");
                button.setStyleName("small");
                button.addClickListener((Button.ClickListener)new PreviewClickListener(SurveillanceViewsConfigList.this.m_surveillanceViewService, (Component)SurveillanceViewsConfigList.this, (View)itemId));
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Default", new Table.ColumnGenerator(){

            public Object generateCell(Table source, Object itemId, Object columnId) {
                CheckBox checkBox = new CheckBox();
                checkBox.setImmediate(true);
                checkBox.setDescription("Make this Surveillance View configuration the default");
                final View view = (View)SurveillanceViewsConfigList.this.m_beanItemContainer.getItem(itemId).getBean();
                checkBox.setValue((Object)SurveillanceViewProvider.getInstance().getSurveillanceViewConfiguration().getDefaultView().equals(view.getName()));
                checkBox.addValueChangeListener(new Property.ValueChangeListener(){

                    public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                        boolean newValue = (Boolean)valueChangeEvent.getProperty().getValue();
                        if (newValue) {
                            SurveillanceViewProvider.getInstance().getSurveillanceViewConfiguration().setDefaultView(view.getName());
                        }
                        SurveillanceViewsConfigList.this.m_table.refreshRowCache();
                        SurveillanceViewProvider.getInstance().save();
                        ((SurveillanceViewsConfigUI)SurveillanceViewsConfigList.this.getUI()).notifyMessage("Data saved", "Default surveillance view");
                    }
                });
                return checkBox;
            }
        });
        this.m_table.setVisibleColumns(new Object[]{"name", "Edit", "Remove", "Preview", "Default"});
        this.m_table.setColumnHeader((Object)"name", "Name");
        this.addComponent((Component)this.m_table);
        this.setExpandRatio((Component)this.m_table, 1.0f);
    }

    public void reloadSurveillanceViews() {
        this.m_beanItemContainer.removeAllItems();
        this.m_beanItemContainer.addAll((Collection)SurveillanceViewProvider.getInstance().getSurveillanceViewConfiguration().getViews());
    }
}

