/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.PlacemarkType;
import com.google.earth.kml._2.ResponseType;
import geo.google.GeoException;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoAddressAccuracy;
import geo.google.datamodel.GeoStatusCode;
import geo.google.mapping.PointToCoordinateFunctor;
import geo.google.mapping.XmlMappingFunctor;
import geo.google.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlToAddressFunctor
implements XmlMappingFunctor<List<GeoAddress>> {
    private static final XmlToAddressFunctor _instance = new XmlToAddressFunctor();
    public static final String JAXB_CONTEXT = "com.google.earth.kml._2";
    private static final Set<GeoStatusCode> SUCCESS = EnumSet.of(GeoStatusCode.G_GEO_SUCCESS);
    private static Unmarshaller _u = null;

    public static XmlToAddressFunctor getInstance() {
        return _instance;
    }

    @Override
    public List<GeoAddress> execute(String xml) throws GeoException {
        ArrayList<GeoAddress> ret = Collections.EMPTY_LIST;
        try {
            Unmarshaller u = this.getUnmarshaller();
            JAXBElement o = (JAXBElement)u.unmarshal(XmlUtils.stringToInputSource(xml));
            ResponseType res = ((KmlType)o.getValue()).getResponse();
            GeoStatusCode status = GeoStatusCode.getStatusCode(res.getStatus().getCode());
            if (!SUCCESS.contains((Object)status)) {
                throw new GeoException("Error Status Code: " + status.getCodeName(), status);
            }
            List<PlacemarkType> placemarks = res.getPlacemark();
            if (CollectionUtils.isNotEmpty(placemarks)) {
                ret = new ArrayList<GeoAddress>(placemarks.size());
                for (PlacemarkType placemark : placemarks) {
                    GeoAddress addr = new GeoAddress();
                    addr.setAddressDetails(placemark.getAddressDetails());
                    addr.setAddressLine(placemark.getAddress());
                    addr.setCoordinate(PointToCoordinateFunctor.getInstance().execute(placemark.getPoint()));
                    if (addr.getAddressDetails() != null && addr.getAddressDetails().getAccuracy() != null) {
                        addr.setAccuracy(GeoAddressAccuracy.getAccuracyByCode(addr.getAddressDetails().getAccuracy()));
                    }
                    ret.add(addr);
                }
            }
            return ret;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to parse xml string using JAXB", e);
        }
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        if (_u == null) {
            _u = JAXBContext.newInstance((String)JAXB_CONTEXT).createUnmarshaller();
        }
        return _u;
    }
}

