/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.opennms.features.apilayer.utils.NodeCriteriaCache;
import org.opennms.integration.api.v1.model.NodeCriteria;
import org.opennms.integration.api.v1.model.immutables.ImmutableNodeCriteria;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

public class NodeCriteriaLoadingCacheImpl
implements NodeCriteriaCache {
    private final LoadingCache<Long, NodeCriteria> nodeIdToCriteriaCache;

    public NodeCriteriaLoadingCacheImpl(final SessionUtils sessionUtils, final NodeDao nodeDao, long nodeIdToCriteriaMaxCacheSize) {
        this.nodeIdToCriteriaCache = CacheBuilder.newBuilder().maximumSize(nodeIdToCriteriaMaxCacheSize).build((CacheLoader)new CacheLoader<Long, NodeCriteria>(){

            public NodeCriteria load(Long nodeId) {
                return (NodeCriteria)sessionUtils.withTransaction(() -> {
                    Objects.requireNonNull(nodeId);
                    OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
                    if (node != null && node.getForeignId() != null && node.getForeignSource() != null) {
                        return ImmutableNodeCriteria.newBuilder().setId(Integer.valueOf(nodeId.intValue())).setForeignId(node.getForeignId()).setForeignSource(node.getForeignSource()).build();
                    }
                    return ImmutableNodeCriteria.newBuilder().setId(Integer.valueOf(nodeId.intValue())).build();
                });
            }
        });
    }

    @Override
    public Optional<NodeCriteria> getNodeCriteria(Long nodeId) {
        Objects.requireNonNull(nodeId);
        try {
            return Optional.of((NodeCriteria)this.nodeIdToCriteriaCache.get((Object)nodeId));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

