/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import java.util.Objects;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class SnmpInterfaceDaoImpl
implements org.opennms.integration.api.v1.dao.SnmpInterfaceDao {
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final SessionUtils sessionUtils;

    public SnmpInterfaceDaoImpl(SnmpInterfaceDao snmpInterfaceDao, SessionUtils sessionUtils) {
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public Long getSnmpInterfaceCount() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsSnmpInterface.class);
        return (Long)this.sessionUtils.withReadOnlyTransaction(() -> this.snmpInterfaceDao.countMatching(criteriaBuilder.toCriteria()));
    }

    public SnmpInterface findByNodeIdAndDescrOrName(Integer nodeId, String descrOrName) {
        return (SnmpInterface)this.sessionUtils.withReadOnlyTransaction(() -> ModelMappers.toSnmpInterface(this.snmpInterfaceDao.findByNodeIdAndDescription(nodeId, descrOrName)));
    }
}

