/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.error;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.error.ErrorTemplate;

public class Error {
    private final String context;
    private final ErrorTemplate template;
    private final Object[] arguments;

    public Error(String context, ErrorTemplate errorTemplate, Object ... arguments) {
        this.context = context;
        this.template = Objects.requireNonNull(errorTemplate);
        this.arguments = arguments;
    }

    private Object[] getArguments() {
        return this.arguments;
    }

    public String getFormattedMessage() {
        return new MessageFormat(this.template.getMessage()).format(this.getArguments());
    }

    public ErrorTemplate getTemplate() {
        return this.template;
    }

    public String getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.template, error.template) && Arrays.equals(this.arguments, error.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.arguments);
    }
}

