/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.osgi.service.cm.ConfigurationAdmin;

public class OsgiKafkaConfigProvider
implements KafkaConfigProvider {
    private final String groupId;
    private final String pid;
    private final String commonPID;
    private final ConfigurationAdmin configAdmin;

    public OsgiKafkaConfigProvider(String groupId, String pid, ConfigurationAdmin configAdmin) {
        this(groupId, pid, configAdmin, null);
    }

    public OsgiKafkaConfigProvider(String groupId, String pid, ConfigurationAdmin configAdmin, String commonPID) {
        this.groupId = groupId;
        this.pid = pid;
        this.configAdmin = configAdmin;
        this.commonPID = commonPID;
    }

    public OsgiKafkaConfigProvider(String pid, ConfigurationAdmin configAdmin) {
        this(null, pid, configAdmin, null);
    }

    public OsgiKafkaConfigProvider(String pid, ConfigurationAdmin configAdmin, String commonPID) {
        this(null, pid, configAdmin, commonPID);
    }

    @Override
    public synchronized Properties getProperties() {
        Properties kafkaConfig = new Properties();
        if (this.groupId != null) {
            kafkaConfig.put("group.id", this.groupId);
        }
        try {
            Dictionary properties = this.configAdmin.getConfiguration(this.pid).getProperties();
            if (properties != null && properties.get("bootstrap.servers") != null) {
                this.convertFromDictionaryToProperties(properties, kafkaConfig);
            } else {
                Dictionary commonPidProperties = this.configAdmin.getConfiguration(this.commonPID).getProperties();
                if (commonPidProperties != null && commonPidProperties.get("bootstrap.servers") != null) {
                    this.convertFromDictionaryToProperties(commonPidProperties, kafkaConfig);
                }
            }
            return kafkaConfig;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties", e);
        }
    }

    private void convertFromDictionaryToProperties(Dictionary<String, Object> properties, Properties kafkaConfig) {
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            kafkaConfig.put(key, properties.get(key));
        }
    }
}

