/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.config.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jms.config.impl.ConnectionFactoryRegistration;
import org.ops4j.pax.jms.config.impl.Decryptor;
import org.ops4j.pax.jms.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jms.config.impl.PoolingWrapper;
import org.ops4j.pax.jms.config.impl.ServiceTrackerHelper;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.PooledConnectionFactoryFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryConfigManager
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFactoryConfigManager.class);
    private BundleContext context;
    private ExternalConfigLoader externalConfigLoader;
    private Map<String, ServiceTracker<?, ?>> trackers;

    public ConnectionFactoryConfigManager(BundleContext context, ExternalConfigLoader externalConfigLoader) {
        this.context = context;
        this.externalConfigLoader = externalConfigLoader;
        this.trackers = new HashMap();
    }

    public String getName() {
        return "connectionfactory";
    }

    public synchronized void updated(String pid, Dictionary config) throws ConfigurationException {
        this.deleted(pid);
        if (config == null) {
            return;
        }
        Dictionary<String, Object> loadedConfig = this.externalConfigLoader.resolve(config);
        String seFilter = ConnectionFactoryConfigManager.getStringEncryptorFilter(loadedConfig);
        String cffFilter = ConnectionFactoryConfigManager.getCFFFilter(loadedConfig);
        String pcffFilter = ConnectionFactoryConfigManager.getPooledCFFFilter(loadedConfig);
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(this.context);
        ServiceTracker<StringEncryptor, ServiceTracker> tracker = Objects.nonNull(pcffFilter) ? helper.track(StringEncryptor.class, seFilter, se -> helper.track(PooledConnectionFactoryFactory.class, pcffFilter, pcff -> helper.track(ConnectionFactoryFactory.class, cffFilter, cff -> new ConnectionFactoryRegistration(this.context, new PoolingWrapper((PooledConnectionFactoryFactory)pcff, (ConnectionFactoryFactory)cff), loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig)), ConnectionFactoryRegistration::close))) : helper.track(StringEncryptor.class, seFilter, se -> helper.track(ConnectionFactoryFactory.class, cffFilter, cff -> new ConnectionFactoryRegistration(this.context, (ConnectionFactoryFactory)cff, loadedConfig, new Decryptor((StringEncryptor)se).decrypt(loadedConfig)), ConnectionFactoryRegistration::close));
        this.trackers.put(pid, tracker);
    }

    static String getStringEncryptorFilter(Dictionary<String, Object> config) {
        if (Decryptor.isEncrypted(config)) {
            String alias = Decryptor.getAlias(config);
            return ConnectionFactoryConfigManager.andFilter(ConnectionFactoryConfigManager.eqFilter("objectClass", StringEncryptor.class.getName()), ConnectionFactoryConfigManager.eqFilter("alias", alias));
        }
        return null;
    }

    static String getCFFFilter(Dictionary<String, Object> config) throws ConfigurationException {
        String cffName = (String)config.get("type");
        if (cffName == null) {
            throw new ConfigurationException(null, "Could not determine provider to use. Specify the type property.");
        }
        return ConnectionFactoryConfigManager.andFilter(ConnectionFactoryConfigManager.eqFilter("objectClass", ConnectionFactoryFactory.class.getName()), ConnectionFactoryConfigManager.eqFilter("type", cffName));
    }

    static String getPooledCFFFilter(Dictionary<String, Object> config) throws ConfigurationException {
        String pool = (String)config.remove("pool");
        boolean isXa = ConnectionFactoryConfigManager.isXa(config);
        if (pool == null) {
            if (isXa) {
                throw new ConfigurationException(null, "Can not create XA Connection Factory without pooling.");
            }
            return null;
        }
        return ConnectionFactoryConfigManager.andFilter(ConnectionFactoryConfigManager.eqFilter("objectClass", PooledConnectionFactoryFactory.class.getName()), ConnectionFactoryConfigManager.eqFilter("pool", pool), ConnectionFactoryConfigManager.eqFilter("xa", Boolean.toString(isXa)));
    }

    static boolean isXa(Dictionary<String, Object> config) throws ConfigurationException {
        String xa = (String)config.remove("xa");
        if (xa == null) {
            return false;
        }
        if ("true".equals(xa)) {
            return true;
        }
        if ("false".equals(xa)) {
            return false;
        }
        throw new ConfigurationException(null, "Invalid XA configuration provided, XA can only be set to true or false");
    }

    static String eqFilter(String key, String value) {
        return value != null ? "(" + key + "=" + value + ")" : null;
    }

    static String andFilter(String ... filterList) {
        String last = null;
        StringBuilder filter = new StringBuilder("(&");
        int count = 0;
        for (String filterPart : filterList) {
            if (filterPart == null) continue;
            last = filterPart;
            filter.append(filterPart);
            ++count;
        }
        filter.append(")");
        return count > 1 ? filter.toString() : last;
    }

    public synchronized void deleted(String pid) {
        ServiceTracker<?, ?> tracker = this.trackers.remove(pid);
        if (tracker != null) {
            tracker.close();
        }
    }

    synchronized void destroy() {
        HashSet<String> pidsToDestroy = new HashSet<String>(this.trackers.keySet());
        for (String pid : pidsToDestroy) {
            this.deleted(pid);
        }
    }
}

