/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerRecord
extends MarshalRecord {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private XPathFragment xPathFragment;
    private AttributesImpl attributes;
    List<String> currentLevelPrefixMappings = null;
    private List<List<String>> prefixMappings = new ArrayList<List<String>>();
    protected boolean isStartElementOpen = false;

    public ContentHandlerRecord() {
        this.attributes = new AttributesImpl();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public void startDocument(String encoding, String version) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
        try {
            this.contentHandler.startPrefixMapping(prefix, namespaceURI);
            if (this.currentLevelPrefixMappings == null) {
                this.currentLevelPrefixMappings = new ArrayList<String>();
            }
            this.currentLevelPrefixMappings.add(prefix);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (namespaceURI != null) {
            this.defaultNamespaceDeclaration(namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry.getKey();
                this.namespaceDeclaration(namespacePrefix, entry.getValue());
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        try {
            this.contentHandler.endPrefixMapping(prefix);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    private void openAndCloseStartElement() {
        try {
            String namespaceUri = this.xPathFragment.getNamespaceURI();
            if (namespaceUri == null) {
                namespaceUri = "";
            }
            if (this.xPathFragment.isGeneratedPrefix()) {
                this.namespaceDeclaration(this.xPathFragment.getPrefix(), this.xPathFragment.getNamespaceURI());
            }
            this.contentHandler.startElement(namespaceUri, this.xPathFragment.getLocalName(), this.getNameForFragment(this.xPathFragment), this.attributes);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        this.currentLevelPrefixMappings = null;
        this.prefixMappings.add(this.currentLevelPrefixMappings);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.xPathFragment = xPathFragment;
        this.attributes.clear();
    }

    @Override
    public void element(XPathFragment frag) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.attributes.clear();
            String namespaceURI = frag.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            String localName = frag.getLocalName();
            String shortName = this.getNameForFragment(frag);
            this.contentHandler.startElement(namespaceURI, localName, shortName, this.attributes);
            this.contentHandler.endElement(namespaceURI, localName, shortName);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        String namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.attribute(namespaceURI, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment), value);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        if (namespaceURI == "http://www.w3.org/2000/xmlns/") {
            if (localName == "xmlns") {
                localName = "";
            }
            this.startPrefixMapping(localName, value);
        }
        this.attributes.addAttribute(namespaceURI, localName, qName, "CDATA", value);
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            String uri = xPathFragment.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            this.contentHandler.endElement(uri, xPathFragment.getLocalName(), this.getNameForFragment(xPathFragment));
            List<String> currentLevelPrefixMappings = this.prefixMappings.remove(this.prefixMappings.size() - 1);
            if (currentLevelPrefixMappings != null) {
                for (String prefix : currentLevelPrefixMappings) {
                    this.contentHandler.endPrefixMapping(prefix);
                }
            }
            this.isStartElementOpen = false;
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void characters(String value) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            char[] characters = value.toCharArray();
            this.contentHandler.characters(characters, 0, characters.length);
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void cdata(String value) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.startCDATA();
            }
            this.characters(value);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.endCDATA();
            }
        }
        catch (SAXException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String uri, String name) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            String namespaceURI = attr.getNamespaceURI();
            String localName = attr.getLocalName();
            if (localName == null) {
                localName = "";
            }
            if (resolverPfx != null) {
                this.attribute(namespaceURI, localName, String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(namespaceURI, localName, attr.getName(), attr.getNodeValue());
                if (namespaceURI != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", localName, "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            if (node.getNodeType() == 3) {
                this.characters(node.getNodeValue());
            } else {
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(this.contentHandler);
                try {
                    xfragReader.parse(node, uri, name);
                }
                catch (SAXException sex) {
                    throw XMLMarshalException.marshalException(sex);
                }
            }
        }
    }

    public String resolveNamespacePrefix(XPathFragment frag, NamespaceResolver resolver) {
        String resolved = frag.getNamespaceURI();
        if (resolved == null) {
            return "";
        }
        return resolved;
    }

    @Override
    public String resolveNamespacePrefix(String s) {
        String resolved = super.resolveNamespacePrefix(s);
        if (resolved == null) {
            return "";
        }
        return resolved;
    }
}

