/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.server.offset;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.OnmsKafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.ipc.sink.kafka.server.offset.HostAndPort;
import org.opennms.core.ipc.sink.kafka.server.offset.KafkaOffset;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaOffsetProvider.class);
    private static final int NUM_RETRIES = 120;
    private static final int INVALID = -1;
    private KafkaOffsetConsumerRunner consumerRunner;
    private final Properties kafkaConfig = new Properties();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("kafka-offset-consumer-%d").build();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactory);
    private static final Map<String, KafkaConsumer> consumerMap = new HashMap<String, KafkaConsumer>();
    private Map<String, Map<Integer, KafkaOffset>> consumerOffsetMap = new ConcurrentHashMap<String, Map<Integer, KafkaOffset>>();
    private Map<String, Long> consumerLagMap = new ConcurrentHashMap<String, Long>();
    private MetricRegistry metricRegistry;
    private JmxReporter reporter = null;
    private final AtomicInteger resetBroker = new AtomicInteger(0);
    private int partitionNumber = -1;
    private HostAndPort kafkaHost;
    private final KafkaConfigProvider configProvider;

    public KafkaOffsetProvider() {
        this((KafkaConfigProvider)new OnmsKafkaConfigProvider("org.opennms.core.ipc.sink.kafka.", "org.opennms.core.ipc.kafka."), null);
    }

    public KafkaOffsetProvider(KafkaConfigProvider configProvider, MetricRegistry metricRegistry) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.metricRegistry = metricRegistry;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry != null ? this.metricRegistry : new MetricRegistry();
    }

    public void setMetricRegistry(MetricRegistry metrics) {
        this.metricRegistry = metrics;
    }

    private long readOffsetMessageValue(ByteBuffer buffer) {
        buffer.getShort();
        long offset = buffer.getLong();
        return offset;
    }

    public KafkaConsumer getConsumer() {
        Object kafkaServer = null;
        if (this.kafkaHost == null) {
            kafkaServer = this.kafkaConfig.get("bootstrap.servers");
            if (kafkaServer == null || !(kafkaServer instanceof String)) {
                throw new IllegalArgumentException("Kafka server is invalid");
            }
            String kafkaString = (String)kafkaServer;
            this.kafkaHost = HostAndPort.fromString(kafkaString);
            if (this.kafkaHost == null) {
                throw new IllegalArgumentException("Kafka server is invalid");
            }
        }
        if (this.resetBroker.get() == 120) {
            LOGGER.trace(" Max num of retries reached, try if there is another broker");
            this.kafkaHost = HostAndPort.getNextHostAndPort(this.kafkaHost);
            if (this.kafkaHost == null) {
                this.consumerRunner.shutdown();
                throw new IllegalArgumentException("Kafka server is invalid");
            }
            this.partitionNumber = -1;
            this.resetBroker.set(0);
        }
        return this.getConsumer(this.kafkaHost.getHost(), this.kafkaHost.getPort());
    }

    public KafkaConsumer getConsumer(String host, int port) {
        KafkaConsumer consumer = consumerMap.get(host + ":" + port);
        if (consumer == null) {
            Properties localKafkaConfig = this.kafkaConfig;
            localKafkaConfig.put("bootstrap.servers", host + ":" + port);
            localKafkaConfig.put("session.timeout.ms", (Object)100000);
            localKafkaConfig.putAll((Map<?, ?>)this.configProvider.getProperties());
            consumer = new KafkaConsumer(localKafkaConfig);
            LOGGER.info("Created a new Kafka Consumer with host  {}:{} ", (Object)host, (Object)port);
            consumerMap.put(host + ":" + port, consumer);
        }
        return consumer;
    }

    public Map<String, Map<Integer, KafkaOffset>> getConsumerOffsetMap() {
        return this.consumerOffsetMap;
    }

    public long getLastOffset(KafkaConsumer consumer, String topic, int partition, long whichTime) {
        long lastOffset;
        block3: {
            lastOffset = 0L;
            try {
                HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
                TopicPartition actualTopicPartition = new TopicPartition(topic, partition);
                partitions.add(actualTopicPartition);
                lastOffset = (Long)consumer.endOffsets(partitions).get(actualTopicPartition);
            }
            catch (Exception e) {
                LOGGER.trace("Error while collecting the log Size for topic: {}:{} ", new Object[]{topic, partition, e});
                if (this.partitionNumber == -1) {
                    this.partitionNumber = partition;
                }
                if (this.partitionNumber != partition) break block3;
                this.resetBroker.getAndIncrement();
            }
        }
        return lastOffset;
    }

    public void closeConnection() throws InterruptedException {
        for (Map.Entry<String, KafkaConsumer> consumer : consumerMap.entrySet()) {
            LOGGER.info("Closing connection for: " + consumer.getKey());
            consumer.getValue().close();
        }
    }

    public void start() {
        this.kafkaConfig.clear();
        this.kafkaConfig.put("enable.auto.commit", "false");
        this.kafkaConfig.put("auto.offset.reset", "latest");
        this.kafkaConfig.put("key.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        this.kafkaConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        this.kafkaConfig.putAll((Map<?, ?>)this.configProvider.getProperties());
        this.consumerRunner = (KafkaOffsetConsumerRunner)Utils.runWithGivenClassLoader(() -> new KafkaOffsetConsumerRunner(), (ClassLoader)KafkaConsumer.class.getClassLoader());
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.getMetricRegistry()).inDomain("org.opennms.core.ipc.sink.kafka").build();
        this.reporter.start();
        this.executor.execute(this.consumerRunner);
    }

    public void stop() throws InterruptedException {
        this.reporter.stop();
        this.consumerRunner.shutdown();
        this.closeConnection();
    }

    private class KafkaOffsetConsumerRunner
    implements Runnable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final KafkaConsumer<byte[], byte[]> consumer;

        public KafkaOffsetConsumerRunner() {
            this.consumer = new KafkaConsumer(KafkaOffsetProvider.this.kafkaConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Logging.putPrefix((String)"ipc");
                this.consumer.subscribe(Arrays.asList("__consumer_offsets"));
                LOGGER.info("Connected to Kafka consumer offset topic");
                Schema schema = new Schema(new Field[]{new Field("group", (Type)Schema.STRING), new Field("topic", (Type)Schema.STRING), new Field("partition", (Type)Schema.INT32)});
                while (!this.closed.get()) {
                    ConsumerRecords records = this.consumer.poll(500L);
                    for (ConsumerRecord consumerRecord : records) {
                        ByteBuffer key;
                        short version;
                        if (consumerRecord.value() == null || consumerRecord.key() == null || (version = (key = ByteBuffer.wrap((byte[])consumerRecord.key())).getShort()) >= 2) continue;
                        try {
                            Struct struct = schema.read(key);
                            String group = struct.getString("group");
                            if (!group.equals(SystemInfoUtils.getInstanceId())) continue;
                            final String topic = struct.getString("topic");
                            int partition = struct.getInt("partition");
                            KafkaConsumer con = KafkaOffsetProvider.this.getConsumer();
                            long realOffset = KafkaOffsetProvider.this.getLastOffset(con, struct.getString("topic"), partition, -1L);
                            long consumerOffset = KafkaOffsetProvider.this.readOffsetMessageValue(ByteBuffer.wrap((byte[])consumerRecord.value()));
                            long lag = 0L;
                            if (realOffset > 0L) {
                                lag = realOffset - consumerOffset;
                            }
                            KafkaOffset mon = new KafkaOffset(group, topic, partition, realOffset, consumerOffset, lag);
                            LOGGER.trace("group : {} , topic: {}:{} , offsets : {}-{}-{}", new Object[]{group, topic, partition, consumerOffset, realOffset, lag});
                            Map<Integer, KafkaOffset> map = KafkaOffsetProvider.this.consumerOffsetMap.get(topic);
                            if (map == null) {
                                map = new ConcurrentHashMap<Integer, KafkaOffset>();
                                KafkaOffsetProvider.this.consumerOffsetMap.put(topic, map);
                                KafkaOffsetProvider.this.getMetricRegistry().register(MetricRegistry.name((String)topic, (String[])new String[]{"Lag"}), (Metric)new Gauge<Long>(){

                                    public Long getValue() {
                                        return KafkaOffsetProvider.this.consumerLagMap.get(topic);
                                    }
                                });
                            }
                            map.put(partition, mon);
                            long totalLag = 0L;
                            for (KafkaOffset offset : map.values()) {
                                totalLag += offset.getLag();
                            }
                            LOGGER.trace(" Total lag for topic {} is {} ", (Object)topic, (Object)totalLag);
                            KafkaOffsetProvider.this.consumerLagMap.put(topic, totalLag);
                        }
                        catch (Exception e) {
                            LOGGER.trace("Exception while getting offset", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.trace("Exception while getting offset", (Throwable)e);
            }
            finally {
                this.consumer.close();
            }
        }

        public void shutdown() {
            this.closed.set(true);
            LOGGER.info("Closing offset consumer");
            this.consumer.wakeup();
        }
    }
}

