/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.persistence.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigStatus;
import org.opennms.netmgt.model.OnmsIpInterface;

@Entity
@Table(name="device_config")
public class DeviceConfig
implements Serializable {
    private static final long serialVersionUID = 1078656993339537763L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="deviceConfigSequence")
    @SequenceGenerator(name="deviceConfigSequence", sequenceName="deviceconfignxtid")
    @Column(name="id", nullable=false)
    private Long id;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="ipinterface_id")
    private OnmsIpInterface ipInterface;
    @Column(name="service_name", nullable=true)
    private String serviceName;
    @Type(type="org.hibernate.type.BinaryType")
    @Column(name="config")
    private byte[] config;
    @Column(name="encoding", nullable=false)
    private String encoding;
    @Column(name="config_type", nullable=false)
    private String configType;
    @Column(name="filename")
    private String fileName;
    @Column(name="failure_reason")
    private String failureReason;
    @Column(name="created_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdTime;
    @Column(name="last_updated")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdated;
    @Column(name="last_failed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastFailed;
    @Column(name="last_succeeded")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastSucceeded;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DeviceConfigStatus status;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public OnmsIpInterface getIpInterface() {
        return this.ipInterface;
    }

    public void setIpInterface(OnmsIpInterface ipInterface) {
        this.ipInterface = ipInterface;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public byte[] getConfig() {
        return this.config;
    }

    public void setConfig(byte[] config) {
        this.config = config;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastFailed() {
        return this.lastFailed;
    }

    public void setLastFailed(Date lastFailed) {
        this.lastFailed = lastFailed;
    }

    public Date getLastSucceeded() {
        return this.lastSucceeded;
    }

    public void setLastSucceeded(Date lastSucceeded) {
        this.lastSucceeded = lastSucceeded;
    }

    public DeviceConfigStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceConfigStatus status) {
        this.status = status;
    }

    public DeviceConfigStatus getStatusOrDefault() {
        return this.status != null ? this.status : DeviceConfigStatus.NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceConfig that = (DeviceConfig)o;
        return Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.lastFailed, that.lastFailed) && Objects.equals(this.lastSucceeded, that.lastSucceeded) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.configType, that.configType) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.failureReason, that.failureReason) && Objects.equals(this.ipInterface, that.ipInterface) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals((Object)this.status, (Object)that.status) && Arrays.equals(this.config, that.config);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.ipInterface, this.serviceName, this.encoding, this.configType, this.fileName, this.failureReason, this.createdTime, this.lastUpdated, this.lastFailed, this.lastSucceeded, this.status});
        result = 31 * result + Arrays.hashCode(this.config);
        return result;
    }
}

