/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class ThresholdEvaluatorRelativeChange
implements ThresholdEvaluator {
    private static final ThresholdType TYPE = ThresholdType.RELATIVE_CHANGE;

    @Override
    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        return new ThresholdEvaluatorStateRelativeChange(threshold, thresholdingSession);
    }

    @Override
    public boolean supportsType(ThresholdType type) {
        return TYPE.equals((Object)type);
    }

    public static class ThresholdEvaluatorStateRelativeChange
    extends AbstractThresholdEvaluatorState<State> {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;

        public ThresholdEvaluatorStateRelativeChange(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
            super(threshold, thresholdingSession, State.class);
            this.setThresholdConfig(threshold);
        }

        @Override
        protected void initializeState() {
            this.state = new State();
        }

        private void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)TYPE.equals((Object)thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + thresholdConfig.getType() + "', but this evaluator only supports thresholds with a 'type' value of '" + TYPE + "'"));
            this.m_thresholdConfig = thresholdConfig;
        }

        @Override
        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        @Override
        public ThresholdEvaluatorState.Status evaluateAfterFetch(double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues) {
            Double multiplier;
            Double d = multiplier = thresholdValues != null && thresholdValues.getThresholdValue() != null ? thresholdValues.getThresholdValue() : this.m_thresholdConfig.getValue();
            if (multiplier == null) {
                return ThresholdEvaluatorState.Status.NO_CHANGE;
            }
            this.setMultiplier(multiplier);
            dsValue = Math.abs(dsValue);
            if (this.getLastSample() != 0.0) {
                double threshold = this.getMultiplier() * this.getLastSample();
                if (this.getMultiplier() < 1.0) {
                    if (dsValue <= threshold) {
                        this.setPreviousTriggeringSample(this.getLastSample());
                        this.setLastSample(dsValue);
                        return ThresholdEvaluatorState.Status.TRIGGERED;
                    }
                } else if (dsValue >= threshold) {
                    this.setPreviousTriggeringSample(this.getLastSample());
                    this.setLastSample(dsValue);
                    return ThresholdEvaluatorState.Status.TRIGGERED;
                }
                this.setLastSample(dsValue);
            }
            this.setLastSample(dsValue);
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        private Double getLastSample() {
            return ((State)this.state).m_lastSample;
        }

        private void setLastSample(double lastSample) {
            if (((State)this.state).m_lastSample != lastSample) {
                ((State)this.state).m_lastSample = lastSample;
                this.markDirty();
            }
        }

        @Override
        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues, CollectionResourceWrapper resource) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI().orElse("uei.opennms.org/threshold/relativeChangeExceeded");
                return this.createBasicEvent(uei, date, dsValue, thresholdValues, resource);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues, CollectionResourceWrapper resource) {
            if (thresholdValues == null) {
                thresholdValues = ((State)this.state).getThresholdValues();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("previousValue", this.formatValue(this.getPreviousTriggeringSample()));
            params.put("multiplier", Double.toString(thresholdValues.getThresholdValue()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        private double getPreviousTriggeringSample() {
            return ((State)this.state).m_previousTriggeringSample;
        }

        private void setPreviousTriggeringSample(double previousTriggeringSample) {
            if (((State)this.state).m_previousTriggeringSample != previousTriggeringSample) {
                ((State)this.state).m_previousTriggeringSample = previousTriggeringSample;
                this.markDirty();
            }
        }

        private double getMultiplier() {
            return ((State)this.state).m_multiplier;
        }

        private void setMultiplier(double multiplier) {
            if (((State)this.state).m_multiplier != multiplier) {
                ((State)this.state).m_multiplier = multiplier;
                this.markDirty();
            }
        }

        @Override
        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateRelativeChange(this.m_thresholdConfig, this.getThresholdingSession());
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        @Override
        public void clearStateBeforePersist() {
            this.initializeState();
        }

        static class State
        extends AbstractThresholdEvaluatorState.AbstractState {
            private static final long serialVersionUID = 1L;
            private double m_multiplier;
            private double m_lastSample = 0.0;
            private double m_previousTriggeringSample;

            State() {
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("multiplier=").append(this.m_multiplier);
                sb.append("\nlastSample=").append(this.m_lastSample);
                sb.append("\npreviousTriggeringSample=").append(this.m_previousTriggeringSample);
                String superString = super.toString();
                if (superString != null) {
                    sb.append("\n").append(superString);
                }
                return sb.toString();
            }
        }
    }
}

