/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.snmp.LldpSnmpUtils;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpRemTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpRemTableTracker.class);
    public static final SnmpObjId LLDP_REM_TABLE_ENTRY = SnmpObjId.get((String)".1.0.8802.1.1.2.1.4.1.1");
    public static final String LLDP_REM_CHASSIS_ID_SUBTYPE = "lldpRemChassisIdSubtype";
    public static final String LLDP_REM_CHASSIS_ID = "lldpRemChassisId";
    public static final String LLDP_REM_PORT_ID_SUBTYPE = "lldpRemPortIdSubtype";
    public static final String LLDP_REM_PORT_ID = "lldpRemPortId";
    public static final String LLDP_REM_PORT_DESCR = "lldpRemPortDesc";
    public static final String LLDP_REM_SYSNAME = "lldpRemSysName";
    public static final SnmpObjId LLDP_REM_CHASSIS_ID_SUBTYPE_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId LLDP_REM_CHASSIS_ID_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId LLDP_REM_PORT_ID_SUBTYPE_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId LLDP_REM_PORT_ID_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId LLDP_REM_PORT_DESCR_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId LLDP_REM_SYSNAME_OID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId[] s_lldpremtable_elemList = new SnmpObjId[]{LLDP_REM_CHASSIS_ID_SUBTYPE_OID, LLDP_REM_CHASSIS_ID_OID, LLDP_REM_PORT_ID_SUBTYPE_OID, LLDP_REM_PORT_ID_OID, LLDP_REM_PORT_DESCR_OID, LLDP_REM_SYSNAME_OID};

    public LldpRemTableTracker() {
        super(s_lldpremtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new LldpRemRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processLldpRemRow((LldpRemRow)row);
    }

    public void processLldpRemRow(LldpRemRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", LLDP_REM_CHASSIS_ID_SUBTYPE_OID + "." + row.getInstance().toString(), LLDP_REM_CHASSIS_ID_SUBTYPE, row.getLldpRemChassisidSubtype(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)row.getLldpRemChassisidSubtype()));
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_REM_CHASSIS_ID_OID + "." + row.getInstance().toString(), LLDP_REM_CHASSIS_ID, LldpSnmpUtils.decodeLldpChassisId(LldpUtils.LldpChassisIdSubType.get((Integer)row.getLldpRemChassisidSubtype()), row.getLldpRemChassisId()));
        System.out.printf("\t\t%s (%s)= %s (%s)\n", LLDP_REM_PORT_ID_SUBTYPE_OID + "." + row.getInstance().toString(), LLDP_REM_PORT_ID_SUBTYPE, row.getLldpRemPortidSubtype(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)row.getLldpRemPortidSubtype()));
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_REM_PORT_ID_OID + "." + row.getInstance().toString(), LLDP_REM_PORT_ID, row.getLldpRemPortid(LldpUtils.LldpPortIdSubType.get((Integer)row.getLldpRemPortidSubtype())));
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_REM_PORT_DESCR_OID + "." + row.getInstance().toString(), LLDP_REM_PORT_DESCR, row.getLldpRemPortDescr());
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_REM_SYSNAME_OID + "." + row.getInstance().toString(), LLDP_REM_SYSNAME, row.getLldpRemSysname());
    }

    public static class LldpRemRow
    extends SnmpRowResult {
        public LldpRemRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getLldpRemLocalPortNum() {
            return this.getInstance().getSubIdAt(1);
        }

        public Integer getLldpRemIndex() {
            LOG.debug("getLldpRemIndex: instance: {}", (Object)this.getInstance());
            if (this.getInstance().getIds().length == 3) {
                return this.getInstance().getSubIdAt(2);
            }
            LOG.warn("getLldpRemIndex: lldpRemIndex: forced to 0, instance {}", (Object)this.getInstance());
            return 0;
        }

        public Integer getLldpRemChassisidSubtype() {
            return this.getValue(LLDP_REM_CHASSIS_ID_SUBTYPE_OID).toInt();
        }

        public SnmpValue getLldpRemChassisId() {
            return this.getValue(LLDP_REM_CHASSIS_ID_OID);
        }

        public Integer getLldpRemPortidSubtype() {
            return this.getValue(LLDP_REM_PORT_ID_SUBTYPE_OID).toInt();
        }

        public String getLldpRemPortid(LldpUtils.LldpPortIdSubType portIdSubType) {
            return LldpSnmpUtils.decodeLldpPortId(portIdSubType, this.getValue(LLDP_REM_PORT_ID_OID));
        }

        public String getLldpRemPortDescr() {
            if (this.getValue(LLDP_REM_PORT_DESCR_OID) != null) {
                return this.getValue(LLDP_REM_PORT_DESCR_OID).toDisplayString();
            }
            return "";
        }

        public String getLldpRemSysname() {
            return this.getValue(LLDP_REM_SYSNAME_OID).toDisplayString();
        }

        public LldpLink getLldpLink() {
            LldpLink lldpLink = new LldpLink();
            lldpLink.setLldpRemLocalPortNum(this.getLldpRemLocalPortNum());
            lldpLink.setLldpRemIndex(this.getLldpRemIndex());
            lldpLink.setLldpRemChassisIdSubType(LldpSnmpUtils.decodeLldpChassisSubType(this.getLldpRemChassisidSubtype()));
            lldpLink.setLldpRemChassisId(LldpSnmpUtils.decodeLldpChassisId(lldpLink.getLldpRemChassisIdSubType(), this.getLldpRemChassisId()));
            lldpLink.setLldpRemSysname(this.getLldpRemSysname());
            lldpLink.setLldpRemPortIdSubType(LldpSnmpUtils.decodeLldpPortSubType(this.getLldpRemPortidSubtype(), this.getValue(LLDP_REM_PORT_ID_OID)));
            lldpLink.setLldpRemPortId(this.getLldpRemPortid(lldpLink.getLldpRemPortIdSubType()));
            lldpLink.setLldpRemPortDescr(this.getLldpRemPortDescr());
            LOG.debug("getLldpLink: local port num: {}, identifier: {}, chassis subtype: {}, \n rem sysname: {}, rem port: {}, rem port subtype: {}", new Object[]{this.getLldpRemLocalPortNum(), lldpLink.getLldpRemChassisId(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)this.getLldpRemChassisidSubtype()), lldpLink.getLldpRemSysname(), lldpLink.getLldpRemPortId(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)this.getLldpRemPortidSubtype())});
            return lldpLink;
        }
    }
}

