/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;

public class DialogWindow
extends Window
implements Button.ClickListener {
    private static final long serialVersionUID = -2235453349601991807L;
    final Button okayButton = new Button("OK", (Button.ClickListener)this);
    final UI parentWindow;

    public DialogWindow(UI parentWindow, String title, String description) {
        this.parentWindow = parentWindow;
        this.setCaption(title);
        this.setResizable(false);
        this.setModal(true);
        this.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.setContent((Component)this.createContent(description));
        parentWindow.addWindow((Window)this);
    }

    private Layout createMainArea(String description) {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.setMargin(true);
        layout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Label label = new Label(description, ContentMode.PREFORMATTED);
        label.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        layout.addComponent((Component)label);
        return layout;
    }

    private Layout createContent(String description) {
        VerticalLayout content = new VerticalLayout();
        content.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Layout footer = this.createFooter();
        Layout mainArea = this.createMainArea(description);
        content.addComponent((Component)mainArea);
        content.addComponent((Component)footer);
        content.setExpandRatio((Component)mainArea, 1.0f);
        return content;
    }

    private Layout createFooter() {
        HorizontalLayout footer = new HorizontalLayout();
        footer.setSpacing(true);
        footer.setMargin(true);
        footer.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        footer.addComponent((Component)this.okayButton);
        footer.setComponentAlignment((Component)this.okayButton, Alignment.BOTTOM_RIGHT);
        return footer;
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.okayButton) {
            this.parentWindow.removeWindow((Window)this);
        }
    }
}

