/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.config.api.collection.IExpression;
import org.opennms.netmgt.config.api.collection.IResourceType;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.internal.collection.ArrayUtils;
import org.opennms.netmgt.config.internal.collection.ColumnImpl;
import org.opennms.netmgt.config.internal.collection.ExpressionImpl;

@XmlRootElement(name="resourceType")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ResourceTypeImpl
implements IResourceType {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="label")
    private String m_label;
    @XmlElement(name="resourceName")
    private ExpressionImpl m_resourceNameExpression;
    @XmlElement(name="resourceLabel")
    private ExpressionImpl m_resourceLabelExpression;
    @XmlElement(name="resourceKind")
    private ExpressionImpl m_resourceKindExpression;
    @XmlElement(name="column")
    private ColumnImpl[] m_columns = new ColumnImpl[0];

    public ResourceTypeImpl() {
    }

    public ResourceTypeImpl(String name, String label) {
        this.m_name = name;
        this.m_label = label;
    }

    public ResourceTypeImpl(ResourceType oldResourceType) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public String getTypeName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public IExpression getResourceNameExpression() {
        return this.m_resourceNameExpression;
    }

    public void setResourceNameExpression(IExpression expression) {
        this.m_resourceNameExpression = ExpressionImpl.asExpression(expression);
    }

    public void setResourceNameTemplate(String template) {
        this.m_resourceNameExpression = new ExpressionImpl(template);
    }

    @Override
    public IExpression getResourceLabelExpression() {
        return this.m_resourceLabelExpression;
    }

    public void setResourceLabelExpression(IExpression expression) {
        this.m_resourceLabelExpression = ExpressionImpl.asExpression(expression);
    }

    public void setResourceLabelTemplate(String template) {
        this.m_resourceLabelExpression = new ExpressionImpl(template);
    }

    @Override
    public IExpression getResourceKindExpression() {
        return this.m_resourceKindExpression;
    }

    public void setResourceKindExpression(IExpression expression) {
        this.m_resourceKindExpression = ExpressionImpl.asExpression(expression);
    }

    public void setResourceKindTemplate(String template) {
        this.m_resourceKindExpression = new ExpressionImpl(template);
    }

    @Override
    public IColumn[] getColumns() {
        return this.m_columns;
    }

    public void setColumns(IColumn[] columns) {
        this.m_columns = ColumnImpl.asColumns(columns);
    }

    public void addColumn(ColumnImpl column) {
        this.m_columns = ArrayUtils.append(this.m_columns, column);
    }

    public void addColumn(String oid, String alias, String type) {
        this.addColumn(new ColumnImpl(oid, alias, type));
    }

    public void addColumn(String oid, String alias, String type, String displayHint) {
        this.addColumn(new ColumnImpl(oid, alias, type, displayHint));
    }

    public String toString() {
        return "ResourceTypeImpl [name=" + this.m_name + ", label=" + this.m_label + ", resourceNameExpression=" + this.m_resourceNameExpression + ", resourceLabelExpression=" + this.m_resourceLabelExpression + ", resourceKindExpression=" + this.m_resourceKindExpression + ", columns=" + Arrays.toString(this.m_columns) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_columns);
        result = 31 * result + (this.m_label == null ? 0 : this.m_label.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_resourceKindExpression == null ? 0 : this.m_resourceKindExpression.hashCode());
        result = 31 * result + (this.m_resourceLabelExpression == null ? 0 : this.m_resourceLabelExpression.hashCode());
        result = 31 * result + (this.m_resourceNameExpression == null ? 0 : this.m_resourceNameExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTypeImpl)) {
            return false;
        }
        ResourceTypeImpl other = (ResourceTypeImpl)obj;
        if (!Arrays.equals(this.m_columns, other.m_columns)) {
            return false;
        }
        if (this.m_label == null ? other.m_label != null : !this.m_label.equals(other.m_label)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_resourceKindExpression == null ? other.m_resourceKindExpression != null : !this.m_resourceKindExpression.equals(other.m_resourceKindExpression)) {
            return false;
        }
        if (this.m_resourceLabelExpression == null ? other.m_resourceLabelExpression != null : !this.m_resourceLabelExpression.equals(other.m_resourceLabelExpression)) {
            return false;
        }
        return !(this.m_resourceNameExpression == null ? other.m_resourceNameExpression != null : !this.m_resourceNameExpression.equals(other.m_resourceNameExpression));
    }
}

