/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMDateTime;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMScope;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.Numeric;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;
import org.sblim.wbem.util.SessionProperties;
import org.sblim.wbem.xml.CIM;
import org.sblim.wbem.xml.CIMRequest;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.Message;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDefaultHandlerImpl
extends DefaultHandler {
    protected static final int CIM = "CIM".hashCode();
    protected static final int CLASS = "CLASS".hashCode();
    protected static final int CLASSNAME = "CLASSNAME".hashCode();
    protected static final int CLASSPATH = "CLASSPATH".hashCode();
    protected static final String EMPTY = "";
    protected static final int ERROR = "ERROR".hashCode();
    protected static final int EXPMETHODCALL = "EXPMETHODCALL".hashCode();
    protected static final int EXPPARAMVALUE = "EXPPARAMVALUE".hashCode();
    protected static final int HOST = "HOST".hashCode();
    protected static final int IMETHODRESPONSE = "IMETHODRESPONSE".hashCode();
    protected static final int INSTANCE = "INSTANCE".hashCode();
    protected static final int INSTANCENAME = "INSTANCENAME".hashCode();
    protected static final int INSTANCEPATH = "INSTANCEPATH".hashCode();
    protected static final int IPARAMVALUE = "IPARAMVALUE".hashCode();
    protected static final int IRETURNVALUE = "IRETURNVALUE".hashCode();
    protected static final int KEYBINDING = "KEYBINDING".hashCode();
    protected static final int KEYVALUE = "KEYVALUE".hashCode();
    protected static final int LOCALCLASSPATH = "LOCALCLASSPATH".hashCode();
    protected static final int LOCALINSTANCEPATH = "LOCALINSTANCEPATH".hashCode();
    protected static final int LOCALNAMESPACEPATH = "LOCALNAMESPACEPATH".hashCode();
    protected static final int MESSAGE = "MESSAGE".hashCode();
    protected static final int METHOD = "METHOD".hashCode();
    protected static final int METHODRESPONSE = "METHODRESPONSE".hashCode();
    protected static final int MULTIEXPREQ = "MULTIEXPREQ".hashCode();
    protected static final int MULTIEXPRSP = "MULTIEXPRSP".hashCode();
    protected static final int MULTIREQ = "MULTIREQ".hashCode();
    protected static final int MULTIRSP = "MULTIRSP".hashCode();
    protected static final int NAMESPACE = "NAMESPACE".hashCode();
    protected static final int NAMESPACEPATH = "NAMESPACEPATH".hashCode();
    protected static final int OBJECTPATH = "OBJECTPATH".hashCode();
    protected static final int PARAMETER = "PARAMETER".hashCode();
    protected static final int PARAMETER_ARRAY = "PARAMETER.ARRAY".hashCode();
    protected static final int PARAMETER_REFARRAY = "PARAMETER.REFARRAY".hashCode();
    protected static final int PARAMETER_REFERENCE = "PARAMETER.REFERENCE".hashCode();
    protected static final int PARAMVALUE = "PARAMVALUE".hashCode();
    protected static final int PROPERTY = "PROPERTY".hashCode();
    protected static final int PROPERTY_ARRAY = "PROPERTY.ARRAY".hashCode();
    protected static final int PROPERTY_REFERENCE = "PROPERTY.REFERENCE".hashCode();
    protected static final int QUALIFIER = "QUALIFIER".hashCode();
    protected static final int QUALIFIER_DECLARATION = "QUALIFIER.DECLARATION".hashCode();
    protected static final int RETURNVALUE = "RETURNVALUE".hashCode();
    protected static final int SCOPE = "SCOPE".hashCode();
    protected static final int SIMPLEEXPREQ = "SIMPLEEXPREQ".hashCode();
    protected static final int SIMPLEEXPRSP = "SIMPLEEXPRSP".hashCode();
    protected static final int SIMPLERSP = "SIMPLERSP".hashCode();
    protected static final int SIMPLREQ = "SIMPLREQ".hashCode();
    protected static final int VALUE = "VALUE".hashCode();
    protected static final int VALUE_ARRAY = "VALUE.ARRAY".hashCode();
    protected static final int VALUE_NAMEDINSTANCE = "VALUE.NAMEDINSTANCE".hashCode();
    protected static final int VALUE_NAMEDOBJECT = "VALUE_NAMEDOBJECT".hashCode();
    protected static final int VALUE_OBJECT = "VALUE.OBJECT".hashCode();
    protected static final int VALUE_OBJECTWITHLOCALPATH = "VALUE.OBJECTWITHLOCALPATH".hashCode();
    protected static final int VALUE_OBJECTWITHPATH = "VALUE.OBJECTWITHPATH".hashCode();
    protected static final int VALUE_REFARRAY = "VALUE.REFARRAY".hashCode();
    protected static final int VALUE_REFERENCE = "VALUE.REFERENCE".hashCode();
    private static final String FALSE = "false";
    private static Writer cOut = new PrintWriter(SessionProperties.getGlobalProperties().getDebugOutputStream());
    private static final String TRUE = "true";
    boolean iDebug = true;
    Vector iElementNames = new Vector();
    int iNn = 0;
    Vector iObjects = new Vector();
    Vector iTmpValues = new Vector();
    StringBuffer iValue = null;
    private int iIndentLevel = 0;
    private String iIndentString = "    ";
    private static final Pattern BIN_PAT = Pattern.compile("^((?:\\+|-)?[01]+)[bB]$");
    private static final Pattern OCT_PAT = Pattern.compile("^(?:\\+|-)?0[0-7]*$");
    private static final Pattern DEC_PAT = Pattern.compile("^(?:\\+|-)?[1-9][0-9]*$");
    private static final Pattern HEX_PAT = Pattern.compile("^(\\+|-)?0[xX]([0-9a-fA-F]+)$");

    public static File[] listAllXml(File baseDir) {
        Vector<File> result = new Vector<File>();
        File[] allXmlFiles = baseDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().endsWith(".xml") && pathname.getName().startsWith("Resp");
            }
        });
        File[] allDirectories = baseDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        result.addAll(Arrays.asList(allXmlFiles));
        for (int i = 0; i < allDirectories.length; ++i) {
            File[] subFiles = XMLDefaultHandlerImpl.listAllXml(allDirectories[i]);
            result.addAll(Arrays.asList(subFiles));
        }
        return result.toArray(new File[result.size()]);
    }

    public static void main(String[] argv) {
        XMLDefaultHandlerImpl handler = new XMLDefaultHandlerImpl();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            cOut = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            SAXParser saxParser = factory.newSAXParser();
            File[] xmlFiles = XMLDefaultHandlerImpl.listAllXml(new File("c:\\code\\cimxml\\"));
            for (int i = 212; i < xmlFiles.length; ++i) {
                System.out.println(i + " - " + xmlFiles[i].getCanonicalPath());
                try {
                    handler.iDebug = false;
                    saxParser.parse(xmlFiles[i], (DefaultHandler)handler);
                    CIMResponse response = (CIMResponse)handler.iObjects.elementAt(0);
                    System.out.println("done\n" + response.getFirstReturnValue());
                    handler.iObjects.removeAllElements();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        handler.iDebug = true;
                        saxParser.parse(xmlFiles[i], (DefaultHandler)handler);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    t.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public XMLDefaultHandlerImpl() {
        this.iDebug = SessionProperties.getGlobalProperties().isDebugXMLInput();
    }

    public XMLDefaultHandlerImpl(boolean debug) {
        this.iDebug = debug;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String eName;
        int tag;
        String value = new String(ch, start, length);
        if (this.iDebug) {
            this.emit(value);
            this.flush();
        }
        if ((tag = (eName = (String)this.iElementNames.lastElement()).hashCode()) == KEYVALUE || tag == VALUE || tag == HOST) {
            if (this.iValue == null) {
                this.iValue = new StringBuffer(value);
            } else {
                this.iValue.append(value);
            }
        }
    }

    private static BigInteger parseBigInteger(String pNumStr) {
        Matcher m = DEC_PAT.matcher(pNumStr);
        if (m.matches()) {
            return new BigInteger(pNumStr);
        }
        m = HEX_PAT.matcher(pNumStr);
        if (m.matches()) {
            String signStr = m.group(1);
            String hexDigits = m.group(2);
            String hexNumStr = signStr == null ? hexDigits : signStr + hexDigits;
            return new BigInteger(hexNumStr, 16);
        }
        m = OCT_PAT.matcher(pNumStr);
        if (m.matches()) {
            return new BigInteger(pNumStr, 8);
        }
        m = BIN_PAT.matcher(pNumStr);
        if (m.matches()) {
            String binDigits = m.group(1);
            return new BigInteger(binDigits, 2);
        }
        throw new NumberFormatException("'" + pNumStr + "' is a not handled number format!");
    }

    public Object createJavaObject(String typeStr, String value) {
        Object o;
        CIMDataType cimType = CIMDataType.getDataType(typeStr, false);
        switch (cimType.getType()) {
            case 0: {
                o = new UnsignedInt8(Short.decode(value));
                break;
            }
            case 2: {
                o = new UnsignedInt16(Integer.decode(value));
                break;
            }
            case 4: {
                o = new UnsignedInt32(Long.decode(value));
                break;
            }
            case 6: {
                o = new UnsignedInt64(XMLDefaultHandlerImpl.parseBigInteger(value));
                break;
            }
            case 1: {
                o = Byte.decode(value);
                break;
            }
            case 3: {
                o = Short.decode(value);
                break;
            }
            case 5: {
                o = Integer.decode(value);
                break;
            }
            case 7: {
                o = Long.decode(value);
                break;
            }
            case 8: {
                o = value;
                break;
            }
            case 9: {
                o = new Boolean(value);
                break;
            }
            case 10: {
                o = new Float(value);
                break;
            }
            case 11: {
                o = new Double(value);
                break;
            }
            case 12: {
                o = CIMDateTime.valueOf(value);
                break;
            }
            case 14: {
                o = new CIMObjectPath(value);
                break;
            }
            case 13: {
                o = new Character(value.charAt(0));
                break;
            }
            case 15: {
                o = new Numeric(XMLDefaultHandlerImpl.parseBigInteger(value).toString());
                break;
            }
            default: {
                o = null;
            }
        }
        return o;
    }

    public void endDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String uri, String lName, String qName) throws SAXException {
        String eName = lName.toUpperCase();
        if (EMPTY.equals(eName)) {
            eName = qName.toUpperCase();
        }
        if (this.iDebug) {
            this.emit("</" + eName + ">");
            this.flush();
            --this.iIndentLevel;
        }
        int tag = eName.hashCode();
        this.iElementNames.remove(this.iElementNames.size() - 1);
        if (tag == CIM || tag == MESSAGE) return;
        if (tag == MULTIRSP) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMResponse) || !(this.iObjects.elementAt(this.iObjects.size() - 1) instanceof CIMResponse)) return;
            CIMResponse simplersp = (CIMResponse)this.pop();
            CIMResponse multirsp = (CIMResponse)this.iObjects.lastElement();
            multirsp.addResponse(simplersp);
            return;
        }
        if (tag == SIMPLERSP) {
            Object obj = null;
            if (this.iObjects.size() <= 1) return;
            obj = this.iObjects.elementAt(this.iObjects.size() - 2);
            CIMResponse response = (CIMResponse)this.pop();
            if (!(obj instanceof CIMResponse)) return;
            CIMResponse multirsp = obj;
            multirsp.addResponse(response);
            return;
        }
        if (tag == MULTIEXPREQ) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMRequest) || !(this.iObjects.elementAt(this.iObjects.size() - 1) instanceof CIMRequest)) return;
            CIMRequest simplereq = (CIMRequest)this.pop();
            CIMRequest multireq = (CIMRequest)this.iObjects.lastElement();
            multireq.addRequest(simplereq);
            return;
        }
        if (tag == SIMPLEEXPREQ) {
            Object obj = null;
            if (this.iObjects.size() <= 1) return;
            obj = this.iObjects.elementAt(this.iObjects.size() - 2);
            CIMRequest request = (CIMRequest)this.pop();
            if (!(obj instanceof CIMResponse)) return;
            CIMRequest multireq = obj;
            multireq.addRequest(request);
            return;
        }
        if (tag == EXPMETHODCALL || tag == EXPPARAMVALUE || tag == IPARAMVALUE || tag == IRETURNVALUE) return;
        if (tag == ERROR) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMException) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) return;
            CIMException e = (CIMException)this.pop();
            CIMResponse response = (CIMResponse)this.iObjects.lastElement();
            response.setError(e);
            return;
        }
        if (tag == KEYVALUE) {
            CIMProperty property;
            if (this.iObjects.size() <= 0 || this.iTmpValues.size() <= 0) throw new SAXException("Inconsistent state of XML parser");
            String valueType = (String)this.iTmpValues.remove(this.iTmpValues.size() - 1);
            CIMDataType type = CIMDataType.getDataType(valueType, false);
            Object o = null;
            try {
                try {
                    o = this.createJavaObject(valueType, this.iValue != null ? this.iValue.toString() : EMPTY);
                }
                catch (NumberFormatException nfe) {
                    valueType = "string";
                    type = CIMDataType.getDataType(valueType, false);
                    o = this.createJavaObject(valueType, this.iValue != null ? this.iValue.toString() : EMPTY);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            CIMValue value = new CIMValue(o, type);
            if (this.iObjects.lastElement() instanceof CIMProperty) {
                property = (CIMProperty)this.iObjects.lastElement();
            } else {
                property = new CIMProperty();
                this.iObjects.add(property);
            }
            property.setValue(value);
            this.iValue = null;
            return;
        }
        if (tag == KEYBINDING) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMProperty) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMObjectPath)) return;
            CIMProperty property = (CIMProperty)this.pop();
            CIMObjectPath objectModel = (CIMObjectPath)this.iObjects.lastElement();
            objectModel.addKey(property);
            return;
        } else if (tag == QUALIFIER) {
            if (this.iTmpValues.size() > 0) {
                this.iTmpValues.remove(this.iTmpValues.size() - 1);
            }
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMQualifier) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMQualifiableElement)) return;
            CIMQualifier qualifier = (CIMQualifier)this.pop();
            CIMQualifiableElement qualifiable = (CIMQualifiableElement)this.iObjects.lastElement();
            qualifiable.addQualifier(qualifier);
            return;
        } else if (tag == HOST) {
            String name;
            CIMNameSpace ns = null;
            String string = name = this.iValue == null ? EMPTY : this.iValue.toString();
            if (name == null || name.length() == 0) {
                throw new SAXException("missing hostname");
            }
            if (this.iObjects.size() <= 0 || !(this.iObjects.lastElement() instanceof CIMNameSpace)) {
                ns = new CIMNameSpace();
                this.iObjects.add(ns);
            } else {
                ns = (CIMNameSpace)this.iObjects.lastElement();
            }
            ns.setHost(name);
            this.iValue = null;
            return;
        } else if (tag == METHOD) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMMethod) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMClass)) return;
            CIMMethod method = (CIMMethod)this.iObjects.remove(this.iObjects.size() - 1);
            CIMClass clazz = (CIMClass)this.iObjects.lastElement();
            clazz.addMethod(method);
            return;
        } else if (tag == PARAMETER) {
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMParameter) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMMethod)) return;
            CIMParameter parameter = (CIMParameter)this.pop();
            CIMMethod method = (CIMMethod)this.iObjects.lastElement();
            method.addParameter(parameter);
            return;
        } else if (tag == PROPERTY || tag == PROPERTY_ARRAY || tag == PROPERTY_REFERENCE) {
            if (tag != PROPERTY_REFERENCE && this.iTmpValues.size() > 0) {
                this.iTmpValues.remove(this.iTmpValues.size() - 1);
            }
            if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMProperty)) return;
            if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMInstance) {
                CIMProperty property = (CIMProperty)this.iObjects.remove(this.iObjects.size() - 1);
                CIMInstance instance = (CIMInstance)this.iObjects.lastElement();
                instance.addProperty(property);
                return;
            } else {
                if (!(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMClass)) return;
                CIMProperty property = (CIMProperty)this.iObjects.remove(this.iObjects.size() - 1);
                CIMClass clazz = (CIMClass)this.iObjects.lastElement();
                clazz.addProperty(property);
            }
            return;
        } else if (tag == CLASSPATH || tag == LOCALCLASSPATH || tag == INSTANCEPATH || tag == LOCALINSTANCEPATH) {
            if (!(this.iObjects.lastElement() instanceof CIMObjectPath) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMNameSpace)) return;
            CIMObjectPath objectPath = (CIMObjectPath)this.pop();
            CIMNameSpace ns = (CIMNameSpace)this.pop();
            objectPath.setHost(ns.getHost());
            objectPath.setNameSpace(ns);
            this.iObjects.add(objectPath);
            return;
        } else if (tag == VALUE || tag == VALUE_ARRAY || tag == VALUE_REFARRAY) {
            CIMResponse response;
            Object result;
            if ((tag == VALUE_ARRAY || tag == VALUE_REFARRAY) && this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof Vector) {
                Vector valueArray = (Vector)this.pop();
                String valueType = (String)this.iTmpValues.lastElement();
                this.iObjects.add(new CIMValue(valueArray, CIMDataType.getDataType(valueType, true)));
            } else if (tag == VALUE) {
                String valueStr;
                if (this.iTmpValues.size() <= 0) throw new SAXException("Error while parsing value: value without type");
                String valueType = (String)this.iTmpValues.lastElement();
                String string = valueStr = this.iValue != null ? this.iValue.toString() : EMPTY;
                if (valueType == null) {
                    // empty if block
                }
                Object o = null;
                if (!(this.iObjects.lastElement() instanceof CIMQualifierType) || !valueStr.equals("NULL")) {
                    o = this.createJavaObject(valueType, valueStr);
                }
                if (((String)this.iElementNames.lastElement()).equalsIgnoreCase("VALUE.ARRAY")) {
                    Vector valueArray = (Vector)this.iObjects.lastElement();
                    valueArray.add(o);
                } else {
                    this.iObjects.add(new CIMValue(o, CIMDataType.getDataType(valueType, false)));
                }
                this.iValue = null;
            }
            if (this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof CIMValue) {
                CIMValue value;
                if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMProperty) {
                    value = (CIMValue)this.pop();
                    CIMProperty property = (CIMProperty)this.iObjects.lastElement();
                    property.setValue(value);
                } else if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMQualifier) {
                    value = (CIMValue)this.pop();
                    CIMQualifier qualifier = (CIMQualifier)this.iObjects.lastElement();
                    qualifier.setValue(value);
                } else if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMArgument) {
                    value = (CIMValue)this.pop();
                    CIMArgument argument = (CIMArgument)this.iObjects.lastElement();
                    argument.setValue(value);
                } else if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMQualifierType) {
                    value = (CIMValue)this.pop();
                    CIMQualifierType qualifierType = (CIMQualifierType)this.iObjects.lastElement();
                    qualifierType.setDefaultValue(value);
                } else {
                    if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof Vector) {
                        throw new SAXException("not implemented");
                    }
                    if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse) {
                        result = this.pop();
                        response = (CIMResponse)this.iObjects.lastElement();
                        response.addReturnValue(result);
                    }
                }
            }
            if (this.iElementNames.size() <= 1 || !((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") || this.iObjects.size() <= 1 || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) return;
            result = this.pop();
            response = (CIMResponse)this.iObjects.lastElement();
            response.addReturnValue(result);
            return;
        } else {
            if (tag == VALUE_NAMEDINSTANCE || tag == VALUE_NAMEDOBJECT) {
                if (this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof CIMInstance && this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMObjectPath) {
                    CIMInstance instance = (CIMInstance)this.pop();
                    CIMObjectPath objectpath = (CIMObjectPath)this.pop();
                    instance.setObjectPath(objectpath);
                    this.iObjects.add(instance);
                }
                if (this.iElementNames.size() > 1 && ((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") && this.iObjects.size() > 1 && this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse) {
                    Object result = this.pop();
                    CIMResponse response = (CIMResponse)this.iObjects.lastElement();
                    response.addReturnValue(result);
                }
                if (this.iElementNames.size() <= 1 || !((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") || this.iObjects.size() <= 2 || this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse) return;
                throw new SAXException("inconsistent state of XML parser");
            }
            if (tag == VALUE_OBJECTWITHPATH || tag == VALUE_OBJECTWITHLOCALPATH) {
                CIMObjectPath objectpath;
                if (this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof CIMInstance) {
                    if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMObjectPath) {
                        CIMInstance instance = (CIMInstance)this.pop();
                        objectpath = (CIMObjectPath)this.pop();
                        instance.setObjectPath(objectpath);
                        this.iObjects.add(instance);
                    }
                } else if (this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof CIMClass && this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMObjectPath) {
                    CIMClass clazz = (CIMClass)this.pop();
                    objectpath = (CIMObjectPath)this.pop();
                    clazz.setObjectPath(objectpath);
                    this.iObjects.add(clazz);
                }
                if (this.iElementNames.size() > 1 && ((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") && this.iObjects.size() > 2 && !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) {
                    throw new SAXException("inconsistent CIMXML parser state");
                }
                if (this.iElementNames.size() <= 1 || !((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") || this.iObjects.size() <= 1 || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) return;
                Object result = this.pop();
                CIMResponse response = (CIMResponse)this.iObjects.lastElement();
                response.addReturnValue(result);
                return;
            } else if (tag == CLASSNAME || tag == INSTANCENAME || tag == VALUE_OBJECT || tag == OBJECTPATH || tag == QUALIFIER_DECLARATION || tag == VALUE_REFERENCE || tag == CLASS || tag == INSTANCE) {
                if (tag == VALUE_REFERENCE && this.iObjects.size() > 1 && this.iObjects.lastElement() instanceof CIMObjectPath) {
                    CIMObjectPath valueReference = (CIMObjectPath)this.pop();
                    if (this.iObjects.lastElement() instanceof CIMProperty) {
                        CIMProperty property = (CIMProperty)this.iObjects.lastElement();
                        property.setValue(new CIMValue(valueReference, CIMDataType.getPredefinedType(14)));
                    } else if (this.iObjects.lastElement() instanceof CIMArgument) {
                        CIMArgument argument = (CIMArgument)this.iObjects.lastElement();
                        argument.setValue(new CIMValue(valueReference, CIMDataType.getPredefinedType(14)));
                    } else {
                        if (!(this.iObjects.lastElement() instanceof Vector)) throw new SAXException("inconsistent XML parser state");
                        Vector valueRefArray = (Vector)this.iObjects.lastElement();
                        valueRefArray.add(valueReference);
                    }
                } else if (tag == QUALIFIER_DECLARATION) {
                    this.iTmpValues.remove(this.iTmpValues.size() - 1);
                }
                if (this.iElementNames.size() > 1 && ((String)this.iElementNames.lastElement()).equalsIgnoreCase("IRETURNVALUE") && this.iObjects.size() > 2 && !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) {
                    throw new SAXException("inconsistent state of XML parser");
                }
                if (this.iElementNames.size() <= 1 || this.iObjects.size() <= 1) return;
                if (this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse) {
                    String elemName = (String)this.iElementNames.lastElement();
                    if (!elemName.equalsIgnoreCase("IRETURNVALUE") && (!elemName.equalsIgnoreCase("RETURNVALUE") || tag != VALUE_REFERENCE)) return;
                    Object result = this.pop();
                    CIMResponse response = (CIMResponse)this.iObjects.lastElement();
                    response.addReturnValue(result);
                    return;
                } else {
                    if (!(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMRequest)) return;
                    Object result = this.pop();
                    CIMRequest request = (CIMRequest)this.iObjects.lastElement();
                    request.addParamValue(result);
                }
                return;
            } else if (tag == SIMPLERSP) {
                if (this.iElementNames.size() <= 1 || !((String)this.iElementNames.lastElement()).equalsIgnoreCase("MULTIRSP") || this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMResponse)) return;
                CIMResponse simplersp = (CIMResponse)this.pop();
                CIMResponse multirsp = (CIMResponse)this.iObjects.lastElement();
                multirsp.addResponse(simplersp);
                return;
            } else if (tag == SIMPLEEXPREQ) {
                if (this.iElementNames.size() <= 1 || !((String)this.iElementNames.lastElement()).equalsIgnoreCase("MULTIEXPREQ") || this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMRequest)) return;
                CIMRequest simplereq = (CIMRequest)this.pop();
                CIMRequest multireq = (CIMRequest)this.iObjects.lastElement();
                multireq.addRequest(simplereq);
                return;
            } else if (tag == PARAMVALUE) {
                if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMArgument) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMResponse)) return;
                Object result = this.pop();
                CIMResponse response = (CIMResponse)this.iObjects.lastElement();
                response.addParamValue(result);
                return;
            } else if (tag == PARAMETER_REFERENCE || tag == PARAMETER_ARRAY || tag == PARAMETER_REFARRAY || tag == PARAMETER) {
                if (this.iObjects.size() <= 1 || !(this.iObjects.lastElement() instanceof CIMParameter) || !(this.iObjects.elementAt(this.iObjects.size() - 2) instanceof CIMMethod)) return;
                CIMParameter parameter = (CIMParameter)this.pop();
                CIMMethod method = (CIMMethod)this.iObjects.lastElement();
                method.addParameter(parameter);
                return;
            } else if (tag == RETURNVALUE) {
                if (this.iTmpValues.size() <= 0) return;
                this.iTmpValues.remove(this.iTmpValues.size() - 1);
                return;
            } else {
                if (tag == NAMESPACEPATH || tag == NAMESPACE || tag == LOCALNAMESPACEPATH || tag == IMETHODRESPONSE || tag == METHODRESPONSE || tag == CIM || tag == MESSAGE || tag == SIMPLERSP || tag == MULTIRSP || tag == SCOPE) return;
                throw new SAXException("Unexpected closing tag " + eName);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }

    public Vector getObjects() {
        return this.iObjects;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public boolean parse(XMLPullParser reader) throws IOException, SAXException {
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    this.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                    break;
                }
                case 2: {
                    this.endElement(EMPTY, EMPTY, reader.getElementName());
                    break;
                }
                case 4: {
                    char[] buf = reader.getText().toCharArray();
                    this.characters(buf, 0, buf.length);
                    break;
                }
            }
        }
        return true;
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.iIndentLevel = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String lName, String qName, Attributes attrs) throws SAXException {
        String name;
        String classname;
        Object message;
        ++this.iIndentLevel;
        String eName = lName.toUpperCase();
        if (EMPTY.equals(eName)) {
            eName = qName.toUpperCase();
        }
        int tag = eName.hashCode();
        if (this.iDebug) {
            this.emit("<" + eName + " ");
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    this.emit(aName);
                    this.emit("=\"");
                    this.emit(attrs.getValue(i));
                    this.emit("\" ");
                }
            }
            this.emit(">");
            this.nl();
            this.flush();
        }
        this.iElementNames.add(eName);
        if (tag == CIM) {
            String cimversion = null;
            String dtdversion = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("CIMVERSION")) {
                        cimversion = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("DTDVERSION")) continue;
                    dtdversion = attrs.getValue(i);
                }
            }
            CIM cim = new CIM(cimversion, dtdversion);
            this.iObjects.add(cim);
            return;
        }
        if (tag == MESSAGE) {
            String id = null;
            String protocolVersion = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("ID")) {
                        id = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("PROTOCOLVERSION")) continue;
                    protocolVersion = attrs.getValue(i);
                }
            }
            Message message2 = new Message(id, protocolVersion);
            this.iObjects.add(message2);
            return;
        }
        if (tag == MULTIRSP || tag == SIMPLERSP) {
            CIMResponse response = new CIMResponse();
            if (this.iObjects.size() > 0 && this.iObjects.lastElement() instanceof Message) {
                message = this.pop();
                if (!(message instanceof Message)) {
                    throw new SAXException("expected MESSAGE element name");
                }
                Object cim = this.pop();
                if (!(cim instanceof CIM)) {
                    throw new SAXException("expected CIM element name");
                }
                response.setMethod(eName);
                response.iCimVersion = ((CIM)cim).iCimVersion;
                response.iDtdVersion = ((CIM)cim).iDtdVersion;
                response.iId = ((Message)message).iId;
                response.iProtocolVersion = ((Message)message).iProtocolVersion;
            }
            this.iObjects.add(response);
            return;
        }
        if (tag == SIMPLEEXPREQ || tag == MULTIEXPREQ) {
            CIMRequest request = new CIMRequest();
            if (this.iObjects.size() > 0 && this.iObjects.lastElement() instanceof Message) {
                message = this.pop();
                if (!(message instanceof Message)) {
                    throw new SAXException("expected MESSAGE element name");
                }
                Object cim = this.pop();
                if (!(cim instanceof CIM)) {
                    throw new SAXException("expected CIM element name");
                }
                request.setMethod(eName);
                request.iCimVersion = ((CIM)cim).iCimVersion;
                request.iDtdVersion = ((CIM)cim).iDtdVersion;
                request.iId = ((Message)message).iId;
                request.iProtocolVersion = ((Message)message).iProtocolVersion;
            }
            this.iObjects.add(request);
            return;
        }
        if (tag == EXPMETHODCALL || tag == EXPPARAMVALUE || tag == IPARAMVALUE || tag == IMETHODRESPONSE || tag == METHODRESPONSE || tag == IRETURNVALUE) return;
        if (tag == ERROR) {
            int errorCode;
            String description;
            block190: {
                String code = null;
                description = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (aName.equalsIgnoreCase("CODE")) {
                            code = attrs.getValue(i);
                            continue;
                        }
                        if (!aName.equalsIgnoreCase("DESCRIPTION")) continue;
                        description = attrs.getValue(i);
                    }
                }
                if (code == null || code.length() == 0) {
                    throw new SAXException("missing error code");
                }
                if (description == null) {
                    description = EMPTY;
                }
                errorCode = 0;
                try {
                    errorCode = Integer.parseInt(code);
                }
                catch (Exception e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block190;
                    logger.log(Level.WARNING, "exception while parsing error code", e);
                }
            }
            this.iObjects.add(new CIMException(CIMException.getStatusFromCode(errorCode), "Remote exception at the CIMOM:" + description));
            return;
        }
        if (tag == INSTANCE) {
            CIMInstance inst = new CIMInstance();
            classname = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (!aName.equalsIgnoreCase("CLASSNAME")) continue;
                    classname = attrs.getValue(i);
                }
            }
            if (classname == null && classname.length() == 0) {
                throw new SAXException("missing instance's classname");
            }
            inst.setClassName(classname);
            this.iObjects.add(inst);
            return;
        }
        if (tag == CLASS) {
            CIMClass clazz = new CIMClass();
            name = null;
            String superclass = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("NAME")) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("SUPERCLASS")) continue;
                    superclass = attrs.getValue(i);
                }
            }
            if (name == null) {
                throw new SAXException("missing class name");
            }
            clazz.setName(name);
            if (superclass != null && superclass.length() > 0) {
                clazz.setSuperClass(superclass);
            }
            this.iObjects.add(clazz);
            return;
        }
        if (tag == METHOD) {
            CIMMethod method = new CIMMethod();
            name = null;
            String type = null;
            String classorigin = null;
            String propagated = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("NAME")) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TYPE")) {
                        type = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("CLASSORIGIN")) {
                        classorigin = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("PROPAGATED")) continue;
                    propagated = attrs.getValue(i);
                }
            }
            method.setName(name);
            if (type != null && type.length() > 0) {
                method.setType(CIMDataType.getDataType(type, false));
            }
            if (classorigin != null && classorigin.length() > 0) {
                method.setOriginClass(classorigin);
            }
            method.setPropagated(TRUE.equalsIgnoreCase(propagated));
            this.iObjects.add(method);
            return;
        }
        if (tag == PARAMETER || tag == PARAMETER_ARRAY || tag == PARAMETER_REFERENCE || tag == PARAMETER_REFARRAY) {
            int arraySize;
            String referenceclass;
            String type;
            CIMParameter parameter;
            block191: {
                parameter = new CIMParameter();
                name = null;
                type = null;
                String arraysize = null;
                referenceclass = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (aName.equalsIgnoreCase("NAME")) {
                            name = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("TYPE")) {
                            type = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("ARRAYSIZE")) {
                            arraysize = attrs.getValue(i);
                            continue;
                        }
                        if (!aName.equalsIgnoreCase("REFERENCECLASS")) continue;
                        referenceclass = attrs.getValue(i);
                    }
                }
                if (name == null) {
                    throw new SAXException("missing property name");
                }
                parameter.setName(name);
                arraySize = -2;
                try {
                    if (arraysize != null && arraysize.length() != 0) {
                        arraySize = Integer.parseInt(arraysize);
                    }
                }
                catch (Exception e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block191;
                    logger.log(Level.WARNING, "exception while parsing array size from parameter", e);
                }
            }
            if (tag == PARAMETER_REFERENCE || tag == PARAMETER_REFARRAY) {
                if (referenceclass == null) {
                    throw new SAXException("missing reference class");
                }
                if (tag == PARAMETER_REFARRAY) {
                    parameter.setType(new CIMDataType(referenceclass, arraySize));
                } else {
                    parameter.setType(new CIMDataType(referenceclass));
                }
            } else {
                if (type == null) {
                    throw new SAXException("missing parameter's type");
                }
                CIMDataType arrayType = CIMDataType.getDataType(type, tag == PARAMETER_ARRAY);
                if (arraySize > -1) {
                    parameter.setType(new CIMDataType(arrayType.getType(), arraySize));
                } else {
                    parameter.setType(arrayType);
                }
            }
            this.iObjects.add(parameter);
            return;
        }
        if (tag == PROPERTY || tag == PROPERTY_ARRAY || tag == PROPERTY_REFERENCE) {
            int arraySize;
            String referenceclass;
            String propagated;
            String classorigin;
            String type;
            CIMProperty property;
            block192: {
                property = new CIMProperty();
                name = null;
                type = null;
                classorigin = null;
                propagated = null;
                String arraysize = null;
                referenceclass = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (aName.equalsIgnoreCase("NAME")) {
                            name = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("TYPE")) {
                            type = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("CLASSORIGIN")) {
                            classorigin = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("PROPAGATED")) {
                            propagated = attrs.getValue(i);
                            continue;
                        }
                        if (aName.equalsIgnoreCase("ARRAYSIZE")) {
                            arraysize = attrs.getValue(i);
                            continue;
                        }
                        if (!aName.equalsIgnoreCase("REFERENCECLASS")) continue;
                        referenceclass = attrs.getValue(i);
                    }
                }
                if (name == null) {
                    throw new SAXException("missing property name");
                }
                property.setName(name);
                arraySize = -2;
                try {
                    if (arraysize != null && arraysize.length() != 0) {
                        arraySize = Integer.parseInt(arraysize);
                    }
                }
                catch (Exception e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block192;
                    logger.log(Level.WARNING, "exception while parsing property's array size", e);
                }
            }
            if (tag != PROPERTY_REFERENCE) {
                if (type == null) throw new SAXException("missing property's type");
                CIMDataType propType = CIMDataType.getDataType(type, tag == PROPERTY_ARRAY);
                if (tag == PROPERTY_ARRAY) {
                    property.setType(new CIMDataType(propType.getType(), arraySize));
                } else {
                    property.setType(propType);
                }
                this.iTmpValues.add(type);
            } else if (referenceclass != null && referenceclass.length() > 0) {
                property.setType(new CIMDataType(referenceclass));
            }
            if (classorigin != null && classorigin.length() > 0) {
                property.setOriginClass(classorigin);
            }
            property.setPropagated(TRUE.equalsIgnoreCase(propagated));
            this.iObjects.add(property);
            return;
        }
        if (tag == QUALIFIER) {
            CIMQualifier qualifier = new CIMQualifier();
            name = null;
            String type = null;
            String propagated = null;
            String overridable = TRUE;
            String tosubclass = TRUE;
            String translatable = FALSE;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("NAME")) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TYPE")) {
                        type = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("OVERRIDABLE")) {
                        overridable = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("PROPAGATED")) {
                        propagated = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TOSUBCLASS")) {
                        tosubclass = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("TRANSLATABLE")) continue;
                    translatable = attrs.getValue(i);
                }
            }
            if (name == null || name.length() == 0) {
                throw new SAXException("missing qualifier name");
            }
            qualifier.setName(name);
            if (type == null || type.length() == 0) {
                throw new SAXException("missing qualifier type");
            }
            this.iTmpValues.add(type);
            qualifier.setPropagated(TRUE.equalsIgnoreCase(propagated));
            if (TRUE.equalsIgnoreCase(overridable)) {
                qualifier.addFlavor(CIMFlavor.getFlavor(0));
            } else {
                qualifier.addFlavor(CIMFlavor.getFlavor(1));
            }
            if (TRUE.equalsIgnoreCase(tosubclass)) {
                qualifier.addFlavor(CIMFlavor.getFlavor(3));
            } else {
                qualifier.addFlavor(CIMFlavor.getFlavor(2));
            }
            if (TRUE.equalsIgnoreCase(translatable)) {
                qualifier.addFlavor(CIMFlavor.getFlavor(4));
            }
            this.iObjects.add(qualifier);
            return;
        } else if (tag == QUALIFIER_DECLARATION) {
            CIMQualifierType qualifierType = new CIMQualifierType();
            name = null;
            String type = null;
            String overridable = TRUE;
            String tosubclass = TRUE;
            String translatable = FALSE;
            String isArray = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (aName.equalsIgnoreCase("NAME")) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TYPE")) {
                        type = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("OVERRIDABLE")) {
                        overridable = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TOSUBCLASS")) {
                        tosubclass = attrs.getValue(i);
                        continue;
                    }
                    if (aName.equalsIgnoreCase("TRANSLATABLE")) {
                        translatable = attrs.getValue(i);
                        continue;
                    }
                    if (!aName.equalsIgnoreCase("ISARRAY")) continue;
                    isArray = attrs.getValue(i);
                }
            }
            if (name == null || name.length() == 0) {
                throw new SAXException("missing qualifier name");
            }
            qualifierType.setName(name);
            if (type == null || type.length() == 0) {
                throw new SAXException("missing qualifier type");
            }
            this.iTmpValues.add(type);
            if (isArray != null) {
                boolean isArrayType = TRUE.equalsIgnoreCase(isArray);
                qualifierType.setType(CIMDataType.getDataType(type, isArrayType));
            }
            if (TRUE.equalsIgnoreCase(overridable)) {
                qualifierType.addFlavor(CIMFlavor.getFlavor(0));
            } else {
                qualifierType.addFlavor(CIMFlavor.getFlavor(1));
            }
            if (TRUE.equalsIgnoreCase(tosubclass)) {
                qualifierType.addFlavor(CIMFlavor.getFlavor(3));
            } else {
                qualifierType.addFlavor(CIMFlavor.getFlavor(2));
            }
            if (TRUE.equalsIgnoreCase(translatable)) {
                qualifierType.addFlavor(CIMFlavor.getFlavor(4));
            }
            this.iObjects.add(qualifierType);
            return;
        } else if (tag == VALUE) {
            if (this.iTmpValues.size() <= 0 || this.iTmpValues.lastElement() != null) return;
            this.iTmpValues.remove(this.iTmpValues.size() - 1);
            String valueType = null;
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (EMPTY.equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (!aName.equalsIgnoreCase("TYPE")) continue;
                    valueType = attrs.getValue(i);
                }
            }
            this.iTmpValues.add(valueType);
            return;
        } else if (tag == VALUE_ARRAY || tag == VALUE_REFARRAY) {
            Vector value_array = new Vector();
            this.iObjects.add(value_array);
            return;
        } else {
            if (tag == VALUE_NAMEDINSTANCE || tag == VALUE_NAMEDOBJECT) return;
            if (tag == HOST) {
                this.iValue = null;
                return;
            } else if (tag == NAMESPACEPATH) {
                if (this.iObjects.size() > 0 && this.iObjects.lastElement() instanceof CIMNameSpace) return;
                CIMNameSpace ns = new CIMNameSpace();
                ns.setNameSpace(EMPTY);
                this.iObjects.add(ns);
                return;
            } else if (tag == LOCALNAMESPACEPATH) {
                if (this.iObjects.size() > 0 && this.iObjects.lastElement() instanceof CIMNameSpace) return;
                CIMNameSpace ns = new CIMNameSpace();
                ns.setNameSpace(EMPTY);
                this.iObjects.add(ns);
                return;
            } else if (tag == NAMESPACE) {
                CIMNameSpace ns;
                name = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (!aName.equalsIgnoreCase("NAME")) continue;
                        name = attrs.getValue(i);
                    }
                }
                if (name == null) {
                    throw new SAXException("missing name space");
                }
                if (this.iObjects.size() <= 0 || !(this.iObjects.lastElement() instanceof CIMNameSpace)) return;
                ns.setNameSpace((ns = (CIMNameSpace)this.iObjects.lastElement()).getNameSpace().length() == 0 ? name : ns.getNameSpace() + '/' + name);
                return;
            } else if (tag == INSTANCENAME || tag == CLASSNAME) {
                CIMObjectPath objectModel = new CIMObjectPath();
                classname = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (aName.equalsIgnoreCase("CLASSNAME")) {
                            classname = attrs.getValue(i);
                        }
                        if (!aName.equalsIgnoreCase("NAME")) continue;
                        classname = attrs.getValue(i);
                    }
                }
                objectModel.setObjectName(classname);
                this.iObjects.add(objectModel);
                return;
            } else if (tag == KEYBINDING) {
                CIMProperty property = new CIMProperty();
                name = null;
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String aName = attrs.getLocalName(i);
                        if (EMPTY.equals(aName)) {
                            aName = attrs.getQName(i);
                        }
                        if (!aName.equalsIgnoreCase("NAME")) continue;
                        name = attrs.getValue(i);
                    }
                }
                property.setName(name);
                property.setPropagated(false);
                this.iObjects.add(property);
                return;
            } else {
                if (tag == VALUE_REFERENCE) return;
                if (tag == KEYVALUE) {
                    this.iValue = null;
                    String valueType = "string";
                    if (attrs != null) {
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String aName = attrs.getLocalName(i);
                            if (EMPTY.equals(aName)) {
                                aName = attrs.getQName(i);
                            }
                            if (!aName.equalsIgnoreCase("VALUETYPE")) continue;
                            valueType = attrs.getValue(i);
                        }
                    }
                    if (valueType == null || valueType.length() == 0) {
                        throw new SAXException("missing key valuetype");
                    }
                    this.iTmpValues.add(valueType);
                    return;
                } else {
                    if (tag == INSTANCEPATH || tag == OBJECTPATH || tag == VALUE_OBJECTWITHPATH || tag == VALUE_OBJECTWITHLOCALPATH) return;
                    if (tag == PARAMVALUE) {
                        CIMArgument argument = new CIMArgument();
                        name = null;
                        String type = null;
                        if (attrs != null) {
                            for (int i = 0; i < attrs.getLength(); ++i) {
                                String aName = attrs.getLocalName(i);
                                if (EMPTY.equals(aName)) {
                                    aName = attrs.getQName(i);
                                }
                                if (aName.equalsIgnoreCase("NAME")) {
                                    name = attrs.getValue(i);
                                    continue;
                                }
                                if (!aName.equalsIgnoreCase("PARAMTYPE")) continue;
                                type = attrs.getValue(i);
                            }
                        }
                        argument.setName(name);
                        this.iTmpValues.add(type);
                        this.iObjects.add(argument);
                        return;
                    } else if (tag == QUALIFIER_DECLARATION) {
                        CIMQualifierType qualifierType = new CIMQualifierType();
                        name = null;
                        String type = null;
                        if (attrs != null) {
                            for (int i = 0; i < attrs.getLength(); ++i) {
                                String aName = attrs.getLocalName(i);
                                if (EMPTY.equals(aName)) {
                                    aName = attrs.getQName(i);
                                }
                                if (aName.equalsIgnoreCase("NAME")) {
                                    name = attrs.getValue(i);
                                    continue;
                                }
                                if (!aName.equalsIgnoreCase("PARAMTYPE")) continue;
                                type = attrs.getValue(i);
                            }
                        }
                        qualifierType.setName(name);
                        if (type == null) {
                            type = EMPTY;
                        }
                        this.iTmpValues.add(type);
                        this.iObjects.add(qualifierType);
                        return;
                    } else if (tag == SCOPE) {
                        if (this.iObjects.size() <= 0 || !(this.iObjects.lastElement() instanceof CIMQualifierType)) return;
                        CIMQualifierType qualifierType = (CIMQualifierType)this.iObjects.lastElement();
                        if (attrs == null) return;
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            String aName = attrs.getLocalName(i);
                            if (EMPTY.equals(aName)) {
                                aName = attrs.getQName(i);
                            }
                            if (aName.equalsIgnoreCase("CLASS") && TRUE.equalsIgnoreCase(attrs.getValue(i))) {
                                qualifierType.addScope(CIMScope.getScope(1));
                                continue;
                            }
                            if (aName.equalsIgnoreCase("ASSOCIATION")) {
                                qualifierType.addScope(CIMScope.getScope(2));
                                continue;
                            }
                            if (aName.equalsIgnoreCase("REFERENCE")) {
                                qualifierType.addScope(CIMScope.getScope(5));
                                continue;
                            }
                            if (aName.equalsIgnoreCase("PROPERTY")) {
                                qualifierType.addScope(CIMScope.getScope(4));
                                continue;
                            }
                            if (aName.equalsIgnoreCase("METHOD")) {
                                qualifierType.addScope(CIMScope.getScope(6));
                                continue;
                            }
                            if (aName.equalsIgnoreCase("PARAMETER")) {
                                qualifierType.addScope(CIMScope.getScope(7));
                                continue;
                            }
                            if (!aName.equalsIgnoreCase("INDICATION")) continue;
                            qualifierType.addScope(CIMScope.getScope(3));
                        }
                        return;
                    } else if (tag == RETURNVALUE) {
                        String type = null;
                        if (attrs != null) {
                            for (int i = 0; i < attrs.getLength(); ++i) {
                                String aName = attrs.getLocalName(i);
                                if (EMPTY.equals(aName)) {
                                    aName = attrs.getQName(i);
                                }
                                if (!aName.equalsIgnoreCase("PARAMTYPE")) continue;
                                type = attrs.getValue(i);
                            }
                        }
                        this.iTmpValues.add(type);
                        return;
                    } else {
                        if (tag == CLASSPATH || tag == LOCALCLASSPATH || tag == LOCALINSTANCEPATH || tag == VALUE_OBJECT) return;
                        throw new SAXException("Unexpected opening tag: " + eName);
                    }
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public String toString() {
        return this.iObjects.toString();
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    protected Object last() {
        return this.iObjects.lastElement();
    }

    protected Object pop() {
        return this.iObjects.remove(this.iObjects.size() - 1);
    }

    private void emit(String s) throws SAXException {
        try {
            cOut.write(s);
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void flush() throws SAXException {
        try {
            cOut.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void nl() throws SAXException {
        String lineEnd = System.getProperty("line.separator");
        try {
            cOut.write(lineEnd);
            for (int i = 0; i < this.iIndentLevel; ++i) {
                cOut.write(this.iIndentString);
            }
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }
}

