/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

public class Benchmark {
    public static final Runtime rt = Runtime.getRuntime();
    public long cumulativeTime = 0L;
    public long elapse = 0L;
    public long currentTime = 0L;
    public long transportCumulativeTime = 0L;
    public long transportElapse = 0L;
    public long transportCurrentTime = 0L;
    public long memory = 0L;
    private static ThreadLocalTimer local = new ThreadLocalTimer();

    public static void resetTime() {
        Benchmark.resetTimer();
    }

    public static void resetTimer() {
        Benchmark timer = local.getLocal();
        timer.cumulativeTime = 0L;
        timer.elapse = 0L;
        timer.transportElapse = 0L;
        timer.transportCurrentTime = 0L;
        timer.memory = 0L;
    }

    public static void startTimer() {
        Benchmark timer = local.getLocal();
        timer.currentTime = System.currentTimeMillis();
    }

    public static void stopTimer() {
        Benchmark timer = local.getLocal();
        timer.elapse = System.currentTimeMillis() - timer.currentTime;
        timer.cumulativeTime += timer.elapse;
    }

    public static long getElapse() {
        Benchmark timer = local.getLocal();
        return timer.elapse;
    }

    public static long getCumulativeTime() {
        Benchmark timer = local.getLocal();
        return timer.cumulativeTime;
    }

    public static void startTransportTimer() {
        Benchmark timer = local.getLocal();
        timer.transportCurrentTime = System.currentTimeMillis();
    }

    public static void stopTransportTimer() {
        Benchmark timer = local.getLocal();
        timer.transportElapse = System.currentTimeMillis() - timer.transportCurrentTime;
        timer.transportCumulativeTime += timer.transportElapse;
    }

    public static long getTransportElapse() {
        Benchmark timer = local.getLocal();
        return timer.transportElapse;
    }

    public static long getTransportCumulativeTime() {
        Benchmark timer = local.getLocal();
        return timer.transportCumulativeTime;
    }

    public static void startMemoryMeter() {
        Benchmark timer = local.getLocal();
        timer.memory = rt.freeMemory();
    }

    public static void stopMemoryMeter() {
        Benchmark timer = local.getLocal();
        timer.memory = rt.freeMemory() - timer.memory;
    }

    public static long getMemoryConsumption() {
        Benchmark timer = local.getLocal();
        return timer.memory;
    }

    public static long showMemory() {
        return 0L;
    }

    public static void gc() {
    }

    private static class ThreadLocalTimer
    extends ThreadLocal {
        private ThreadLocalTimer() {
        }

        public Object initialValue() {
            return new Benchmark();
        }

        public Benchmark getLocal() {
            return (Benchmark)super.get();
        }
    }
}

