/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.attrsummary.Summary;
import org.opennms.web.svclayer.model.SummarySpecification;
import org.opennms.web.svclayer.rrd.RrdSummaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractView;

@Controller
@RequestMapping(value={"/summary/results.htm"})
public class RrdSummaryController {
    @Autowired
    private RrdSummaryService m_rrdSummaryService;

    private ModelAndView getSummary(SummarySpecification spec) {
        Summary summary = this.m_rrdSummaryService.getSummary(spec);
        return new ModelAndView((View)new MarshalledView(), "summary", (Object)summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView processFormSubmission(HttpServletResponse response, SummarySpecification command) {
        RrdSummaryController rrdSummaryController = this;
        synchronized (rrdSummaryController) {
            ModelAndView summary = this.getSummary(command);
            response.setContentType(summary.getView().getContentType());
            return summary;
        }
    }

    public void setRrdSummaryService(RrdSummaryService rrdSummaryService) {
        this.m_rrdSummaryService = rrdSummaryService;
    }

    private static class MarshalledView
    extends AbstractView {
        private MarshalledView() {
        }

        public String getContentType() {
            return "text/xml";
        }

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            Assert.notNull((Object)model.get("summary"), (String)"summary must not be null.. unable to marshall xml");
            JaxbUtils.marshal((Object)model.get("summary"), (Writer)response.getWriter());
        }
    }
}

