/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PsParser
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PsParser.class);
    private final Set<Integer> m_processes = Collections.synchronizedSet(new HashSet());
    private DataInputStream m_input;
    private final String m_matchText;
    private final String m_skipText;
    private final int m_matchField;

    public PsParser(DataInputStream input, String matchText, String skipText, int matchField) {
        this.m_input = input;
        this.m_matchText = matchText;
        this.m_skipText = skipText;
        this.m_matchField = matchField;
    }

    @Override
    public void run() {
        InputStreamReader isr = new InputStreamReader(this.m_input);
        BufferedReader reader = new BufferedReader(isr);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains(this.m_matchText)) {
                    if (this.m_skipText != null && this.m_skipText.length() > 0 && line.contains(this.m_skipText)) {
                        LOG.debug("skipped match: {}", (Object)line);
                        continue;
                    }
                    LOG.debug("found match: {}", (Object)line);
                    String[] entries = line.split(" +");
                    this.m_processes.add(Integer.valueOf(entries[this.m_matchField]));
                }
                if (!this.isInterrupted()) continue;
                break;
            }
        }
        catch (IOException e) {
            if (!e.getMessage().contains("Write end dead")) {
                LOG.debug("An error occurred matching '{}' for field '{}' in the input stream.", new Object[]{this.m_matchText, this.m_matchField, e});
            }
        }
        catch (Exception e) {
            LOG.debug("An error occurred matching '{}' for field '{}' in the input stream.", new Object[]{this.m_matchText, this.m_matchField, e});
        }
    }

    public Set<Integer> getProcesses() {
        return this.m_processes;
    }
}

