/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationEngineReloader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationEngineReloader.class);
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public ClassificationEngineReloader(Identity identity, ClassificationEngine engine, String reloadIntervalString) {
        if (identity != null) {
            int reloadInterval = Integer.parseInt(reloadIntervalString);
            LOG.debug("Scheduling reload of classification engine every {} seconds", (Object)reloadInterval);
            this.executorService.scheduleWithFixedDelay(() -> {
                LOG.debug("Performing reload of Classification Engine...");
                try {
                    engine.reload();
                }
                catch (InterruptedException e) {
                    LOG.error("reload was interrupted", (Throwable)e);
                }
                LOG.debug("Reload of Classification Engine performed. Next reload will be in {} seconds", (Object)reloadInterval);
            }, reloadInterval, reloadInterval, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        LOG.debug("Shutting down {}", (Object)this.getClass().getSimpleName());
        this.executorService.shutdown();
    }
}

