/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.opennmsDataSources;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.mate.api.SecureCredentialsVaultScope;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.jceks.JCEKSSecureCredentialsVault;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="jdbc-data-source")
@XmlAccessorType(value=XmlAccessType.NONE)
public class JdbcDataSource
implements Serializable {
    private static final long serialVersionUID = -1120653287571635877L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataSource.class);
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="database-name")
    private String databaseName;
    @XmlAttribute(name="schema-name")
    private String schemaName;
    @XmlAttribute(name="url", required=true)
    private String url;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlAttribute(name="user-name")
    private String rawUserName;
    @XmlAttribute(name="password")
    private String rawPassword;
    @XmlElement(name="connection-pool")
    private ConnectionPool connectionPool;
    @XmlElement(name="param")
    private List<Param> paramList = new ArrayList<Param>();

    public void addParam(Param vParam) throws IndexOutOfBoundsException {
        this.paramList.add(vParam);
    }

    public void addParam(int index, Param vParam) throws IndexOutOfBoundsException {
        this.paramList.add(index, vParam);
    }

    public Enumeration<Param> enumerateParam() {
        return Collections.enumeration(this.paramList);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JdbcDataSource) {
            JdbcDataSource temp = (JdbcDataSource)obj;
            return Objects.equals(temp.name, this.name) && Objects.equals(temp.databaseName, this.databaseName) && Objects.equals(temp.schemaName, this.schemaName) && Objects.equals(temp.url, this.url) && Objects.equals(temp.className, this.className) && Objects.equals(temp.rawUserName, this.rawUserName) && Objects.equals(temp.rawPassword, this.rawPassword) && Objects.equals(temp.paramList, this.paramList) && Objects.equals(temp.connectionPool, this.connectionPool);
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "opennms";
    }

    public String getName() {
        return this.name;
    }

    public Param getParam(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paramList.size()) {
            throw new IndexOutOfBoundsException("getParam: Index value '" + index + "' not in range [0.." + (this.paramList.size() - 1) + "]");
        }
        return this.paramList.get(index);
    }

    public Param[] getParam() {
        Param[] array = new Param[]{};
        return this.paramList.toArray(array);
    }

    public List<Param> getParamCollection() {
        return this.paramList;
    }

    public int getParamCount() {
        return this.paramList.size();
    }

    public String getRawPassword() {
        return this.rawPassword;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRawUserName() {
        return this.rawUserName;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.databaseName, this.schemaName, this.url, this.className, this.rawUserName, this.rawPassword, this.paramList, this.connectionPool);
    }

    public Iterator<Param> iterateParam() {
        return this.paramList.iterator();
    }

    public void removeAllParam() {
        this.paramList.clear();
    }

    public boolean removeParam(Param vParam) {
        return this.paramList.remove(vParam);
    }

    public Param removeParamAt(int index) {
        Param obj = this.paramList.remove(index);
        return obj;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Hidden
    public void setParam(int index, Param vParam) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paramList.size()) {
            throw new IndexOutOfBoundsException("setParam: Index value '" + index + "' not in range [0.." + (this.paramList.size() - 1) + "]");
        }
        this.paramList.set(index, vParam);
    }

    @Hidden
    public void setParam(Param[] vParamArray) {
        this.paramList.clear();
        for (int i = 0; i < vParamArray.length; ++i) {
            this.paramList.add(vParamArray[i]);
        }
    }

    public void setParam(List<Param> vParamList) {
        this.paramList.clear();
        this.paramList.addAll(vParamList);
    }

    @Hidden
    public void setParamCollection(List<Param> paramList) {
        this.paramList = paramList;
    }

    public void setPassword(String rawPassword) {
        this.rawPassword = rawPassword;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String rawUserName) {
        this.rawUserName = rawUserName;
    }

    public String interpolateAttribute(String value) {
        return this.interpolateAttribute(value, JCEKSSecureCredentialsVault.defaultScv());
    }

    public String interpolateAttribute(String value, SecureCredentialsVault secureCredentialsVault) {
        Interpolator.Result result = Interpolator.interpolate((String)value, (Scope)new SecureCredentialsVaultScope(secureCredentialsVault));
        return result.output;
    }

    public String getUserName() {
        return this.interpolateAttribute(this.getRawUserName());
    }

    public String getPassword() {
        return this.interpolateAttribute(this.getRawPassword());
    }
}

