/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geolocation.services;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderResult;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.GeocoderServiceManager;
import org.opennms.features.geolocation.api.Coordinates;
import org.opennms.features.geolocation.api.GeolocationResolver;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGeolocationResolver
implements GeolocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGeolocationResolver.class);
    private final NodeDao nodeDao;
    private final GeocoderServiceManager geocoderServiceManager;

    public DefaultGeolocationResolver(GeocoderServiceManager geocoderServiceManager, NodeDao nodeDao) {
        this.geocoderServiceManager = Objects.requireNonNull(geocoderServiceManager);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public Map<Integer, Coordinates> resolve(Collection<Integer> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return new HashMap<Integer, Coordinates>();
        }
        Criteria criteria = new CriteriaBuilder(OnmsNode.class).in("id", nodeIds).toCriteria();
        Map<Integer, String> nodeIdAddressMap = this.nodeDao.findMatching(criteria).stream().filter(n -> DefaultGeolocationResolver.getGeoLocation(n) != null).filter(n -> DefaultGeolocationResolver.getGeoLocation(n).getLatitude() == null && DefaultGeolocationResolver.getGeoLocation(n).getLongitude() == null).filter(n -> !Strings.isNullOrEmpty((String)DefaultGeolocationResolver.getGeoLocation(n).asAddressString())).collect(Collectors.toMap(OnmsNode::getId, n -> n.getAssetRecord().getGeolocation().asAddressString()));
        return this.resolve(nodeIdAddressMap);
    }

    public Map<Integer, Coordinates> resolve(Map<Integer, String> nodeIdAddressMap) {
        if (nodeIdAddressMap == null || nodeIdAddressMap.isEmpty()) {
            return new HashMap<Integer, Coordinates>();
        }
        nodeIdAddressMap = nodeIdAddressMap.entrySet().stream().filter(e -> !Strings.isNullOrEmpty((String)((String)e.getValue())) && e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<Integer, Coordinates> resultMap = new HashMap<Integer, Coordinates>();
        nodeIdAddressMap.entrySet().stream().forEach(entry -> {
            String addressString = (String)entry.getValue();
            Coordinates coordinates = this.resolve(addressString);
            if (coordinates != null) {
                resultMap.put((Integer)entry.getKey(), coordinates);
            }
        });
        return resultMap;
    }

    public Coordinates resolve(String addressString) {
        GeocoderService activeGeocoder = this.geocoderServiceManager.getActiveGeocoderService();
        if (activeGeocoder == null) {
            LOG.warn("Error resolving address '{}': No active Geocoder", (Object)addressString);
            return null;
        }
        try {
            GeocoderResult result = activeGeocoder.resolveAddress(addressString);
            if (result.hasError()) {
                LOG.error("Error resolving address '{}': {}", new Object[]{addressString, result.getThrowable().getMessage(), result.getThrowable()});
                return null;
            }
            if (result.isEmpty()) {
                LOG.warn("Error resolving address '{}': Response was empty", (Object)addressString);
                return null;
            }
            org.opennms.features.geocoder.Coordinates coordinates = result.getCoordinates();
            LOG.debug("Successfully resolved address '{}': Active Geocoder with id '{}' resolved to long/lat: {}/{}", new Object[]{addressString, activeGeocoder.getId(), coordinates.getLongitude(), coordinates.getLatitude()});
            return new Coordinates(coordinates.getLongitude(), coordinates.getLatitude());
        }
        catch (GeocoderConfigurationException ex) {
            LOG.warn("Error resolving address '{}': Active Geocoder with id '{}' is not configured properly", new Object[]{addressString, activeGeocoder.getId(), ex});
            return null;
        }
        catch (Exception ex) {
            LOG.warn("Error resolving address '{}': An unexpected exception occurred", (Object)addressString, (Object)ex);
            return null;
        }
    }

    private static OnmsGeolocation getGeoLocation(OnmsNode node) {
        if (node != null && node.getAssetRecord() != null && node.getAssetRecord().getGeolocation() != null) {
            return node.getAssetRecord().getGeolocation();
        }
        return null;
    }
}

