/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.internal.Creator;
import org.jvnet.hk2.internal.InstanceLifecycleEventImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

public class FactoryCreator<T>
implements Creator<T> {
    private final ServiceLocator locator;
    private final ActiveDescriptor<?> factoryDescriptor;

    FactoryCreator(ServiceLocator locator, ActiveDescriptor<?> factoryDescriptor) {
        this.locator = locator;
        this.factoryDescriptor = factoryDescriptor;
    }

    @Override
    public List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    private ServiceHandle<Factory<T>> getFactoryHandle() {
        try {
            return this.locator.getServiceHandle(this.factoryDescriptor);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    @Override
    public T create(ServiceHandle<?> root, SystemDescriptor<?> eventThrower) throws MultiException {
        ServiceHandle<Factory<T>> handle = this.getFactoryHandle();
        eventThrower.invokeInstanceListeners(new InstanceLifecycleEventImpl(InstanceLifecycleEventType.PRE_PRODUCTION, null, eventThrower));
        Factory<T> retValFactory = handle.getService();
        T retVal = retValFactory.provide();
        eventThrower.invokeInstanceListeners(new InstanceLifecycleEventImpl(InstanceLifecycleEventType.POST_PRODUCTION, retVal, eventThrower));
        return retVal;
    }

    @Override
    public void dispose(T instance) {
        try {
            ServiceHandle<Factory<T>> handle = this.getFactoryHandle();
            Factory<T> factory = handle.getService();
            factory.dispose(instance);
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                throw (MultiException)th;
            }
            throw new MultiException(th);
        }
    }
}

