/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.thresholding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.thresholding.FilterOperator;
import org.opennms.integration.api.xml.schema.thresholding.FilterOperatorAdapter;
import org.opennms.integration.api.xml.schema.thresholding.ResourceFilter;
import org.opennms.integration.api.xml.schema.thresholding.ThresholdType;

@XmlRootElement(name="basethresholddef")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Basethresholddef
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final FilterOperator DEFAULT_FILTER_OPERATOR = FilterOperator.OR;
    @XmlAttribute(name="relaxed")
    private Boolean m_relaxed;
    @XmlAttribute(name="description")
    private String m_description;
    @XmlAttribute(name="type", required=true)
    private ThresholdType m_type;
    @XmlAttribute(name="ds-type", required=true)
    private String m_dsType;
    @XmlAttribute(name="value", required=true)
    private String m_value;
    @XmlAttribute(name="rearm", required=true)
    private String m_rearm;
    @XmlAttribute(name="trigger", required=true)
    private String m_trigger;
    @XmlAttribute(name="ds-label")
    private String m_dsLabel;
    @XmlAttribute(name="triggeredUEI")
    private String m_triggeredUEI;
    @XmlAttribute(name="rearmedUEI")
    private String m_rearmedUEI;
    @XmlAttribute(name="filterOperator")
    @XmlJavaTypeAdapter(value=FilterOperatorAdapter.class)
    private FilterOperator m_filterOperator;
    @XmlElement(name="resource-filter")
    private List<ResourceFilter> m_resourceFilters = new ArrayList<ResourceFilter>();

    public Boolean getRelaxed() {
        return this.m_relaxed != null ? this.m_relaxed : Boolean.FALSE;
    }

    public void setRelaxed(Boolean relaxed) {
        this.m_relaxed = relaxed;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.m_description);
    }

    public void setDescription(String description) {
        this.m_description = ConfigUtils.normalizeAndTrimString(description);
    }

    public ThresholdType getType() {
        return this.m_type;
    }

    public void setType(ThresholdType type) {
        this.m_type = ConfigUtils.assertNotNull(type, "type");
    }

    public String getDsType() {
        return this.m_dsType;
    }

    public void setDsType(String dsType) {
        this.m_dsType = ConfigUtils.assertNotEmpty(dsType, "ds-type");
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        this.m_value = ConfigUtils.assertNotNull(value, "value");
    }

    public String getRearm() {
        return this.m_rearm;
    }

    public void setRearm(String rearm) {
        this.m_rearm = ConfigUtils.assertNotNull(rearm, "rearm");
    }

    public String getTrigger() {
        return this.m_trigger;
    }

    public void setTrigger(String trigger) {
        this.m_trigger = ConfigUtils.assertNotNull(trigger, "trigger");
    }

    public Optional<String> getDsLabel() {
        return Optional.ofNullable(this.m_dsLabel);
    }

    public void setDsLabel(String dsLabel) {
        this.m_dsLabel = ConfigUtils.normalizeString(dsLabel);
    }

    public Optional<String> getTriggeredUEI() {
        return Optional.ofNullable(this.m_triggeredUEI);
    }

    public void setTriggeredUEI(String triggeredUEI) {
        this.m_triggeredUEI = ConfigUtils.normalizeString(triggeredUEI);
    }

    public Optional<String> getRearmedUEI() {
        return Optional.ofNullable(this.m_rearmedUEI);
    }

    public void setRearmedUEI(String rearmedUEI) {
        this.m_rearmedUEI = ConfigUtils.normalizeString(rearmedUEI);
    }

    public FilterOperator getFilterOperator() {
        return this.m_filterOperator != null ? this.m_filterOperator : DEFAULT_FILTER_OPERATOR;
    }

    public void setFilterOperator(FilterOperator filterOperator) {
        this.m_filterOperator = filterOperator;
    }

    public List<ResourceFilter> getResourceFilters() {
        return this.m_resourceFilters;
    }

    public void setResourceFilters(List<ResourceFilter> resourceFilters) {
        if (resourceFilters == this.m_resourceFilters) {
            return;
        }
        this.m_resourceFilters.clear();
        if (resourceFilters != null) {
            this.m_resourceFilters.addAll(resourceFilters);
        }
    }

    public void addResourceFilter(ResourceFilter vResourceFilter) throws IndexOutOfBoundsException {
        this.m_resourceFilters.add(vResourceFilter);
    }

    public boolean removeResourceFilter(ResourceFilter resourceFilter) {
        return this.m_resourceFilters.remove(resourceFilter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_relaxed, this.m_description, this.m_type, this.m_dsType, this.m_value, this.m_rearm, this.m_trigger, this.m_dsLabel, this.m_triggeredUEI, this.m_rearmedUEI, this.m_filterOperator, this.m_resourceFilters});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Basethresholddef) {
            Basethresholddef that = (Basethresholddef)obj;
            return Objects.equals(this.m_relaxed, that.m_relaxed) && Objects.equals(this.m_description, that.m_description) && Objects.equals((Object)this.m_type, (Object)that.m_type) && Objects.equals(this.m_dsType, that.m_dsType) && Objects.equals(this.m_value, that.m_value) && Objects.equals(this.m_rearm, that.m_rearm) && Objects.equals(this.m_trigger, that.m_trigger) && Objects.equals(this.m_dsLabel, that.m_dsLabel) && Objects.equals(this.m_triggeredUEI, that.m_triggeredUEI) && Objects.equals(this.m_rearmedUEI, that.m_rearmedUEI) && Objects.equals((Object)this.m_filterOperator, (Object)that.m_filterOperator) && Objects.equals(this.m_resourceFilters, that.m_resourceFilters);
        }
        return false;
    }
}

