/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="ospfArea")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class OspfArea
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(OspfArea.class);
    private static final long serialVersionUID = 3798160983917807494L;
    private Integer m_id;
    private OnmsNode m_node;
    private InetAddress m_ospfAreaId;
    private Integer m_ospfAuthType;
    private Integer m_ospfImportAsExtern;
    private Integer m_ospfAreaBdrRtrCount;
    private Integer m_ospfAsBdrRtrCount;
    private Integer m_ospfAreaLsaCount;
    private Date m_ospfAreaCreateTime = new Date();
    private Date m_ospfAreaLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @Column(name="ospfAreaId")
    public InetAddress getOspfAreaId() {
        return this.m_ospfAreaId;
    }

    @Column(name="ospfAuthType")
    public Integer getOspfAuthType() {
        return this.m_ospfAuthType;
    }

    @Column(name="ospfImportAsExtern")
    public Integer getOspfImportAsExtern() {
        return this.m_ospfImportAsExtern;
    }

    @Column(name="ospfAreaBdrRtrCount")
    public Integer getOspfAreaBdrRtrCount() {
        return this.m_ospfAreaBdrRtrCount;
    }

    @Column(name="ospfAsBdrRtrCount")
    public Integer getOspfAsBdrRtrCount() {
        return this.m_ospfAsBdrRtrCount;
    }

    @Column(name="ospfAreaLsaCount")
    public Integer getOspfAreaLsaCount() {
        return this.m_ospfAreaLsaCount;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfAreaCreateTime", nullable=false)
    public Date getOspfAreaCreateTime() {
        return this.m_ospfAreaCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ospfAreaLastPollTime", nullable=false)
    public Date getOspfAreaLastPollTime() {
        return this.m_ospfAreaLastPollTime;
    }

    public OspfArea setId(Integer id) {
        this.m_id = id;
        return this;
    }

    public OspfArea setNode(OnmsNode node) {
        this.m_node = node;
        return this;
    }

    public OspfArea setOspfAreaId(InetAddress ospfAreaId) {
        this.m_ospfAreaId = ospfAreaId;
        return this;
    }

    public OspfArea setOspfAuthType(Integer ospfAuthType) {
        this.m_ospfAuthType = ospfAuthType;
        return this;
    }

    public OspfArea setOspfImportAsExtern(Integer ospfImportAsExtern) {
        this.m_ospfImportAsExtern = ospfImportAsExtern;
        return this;
    }

    public OspfArea setOspfAreaBdrRtrCount(Integer ospfAreaBdrRtrCount) {
        this.m_ospfAreaBdrRtrCount = ospfAreaBdrRtrCount;
        return this;
    }

    public OspfArea setOspfAsBdrRtrCount(Integer ospfAsBdrRtrCount) {
        this.m_ospfAsBdrRtrCount = ospfAsBdrRtrCount;
        return this;
    }

    public OspfArea setOspfAreaLsaCount(Integer ospfAreaLsaCount) {
        this.m_ospfAreaLsaCount = ospfAreaLsaCount;
        return this;
    }

    public OspfArea setOspfAreaCreateTime(Date ospfAreaCreateTime) {
        this.m_ospfAreaCreateTime = ospfAreaCreateTime;
        return this;
    }

    public OspfArea setOspfAreaLastPollTime(Date ospfAreaLastPollTime) {
        this.m_ospfAreaLastPollTime = ospfAreaLastPollTime;
        return this;
    }

    public String toString() {
        return "ospfArea: nodeid:[" + (this.getNode() != null ? this.getNode().getId() : null) + "]: area [" + InetAddressUtils.str((InetAddress)this.getOspfAreaId()) + "/" + this.getOspfAuthType() + "/" + this.getOspfImportAsExtern() + "/" + this.getOspfAreaBdrRtrCount() + "/" + this.getOspfAsBdrRtrCount() + "/" + this.getOspfAreaLsaCount() + "]";
    }

    public void merge(OspfArea area) {
        if (area == null) {
            return;
        }
        this.setOspfAreaId(area.getOspfAreaId());
        this.setOspfAuthType(area.getOspfAuthType());
        this.setOspfImportAsExtern(area.getOspfImportAsExtern());
        this.setOspfAreaBdrRtrCount(area.getOspfAreaBdrRtrCount());
        this.setOspfAsBdrRtrCount(area.getOspfAsBdrRtrCount());
        this.setOspfAreaLsaCount(area.getOspfAreaLsaCount());
        this.setOspfAreaCreateTime(area.getOspfAreaCreateTime());
        this.setOspfAreaLastPollTime(area.getOspfAreaCreateTime());
    }

    public static enum ImportAsExtern {
        IMPORT_EXTERNAL(1),
        IMPORT_NO_EXTERNAL(2),
        IMPORT_NSSA(3);

        private final int value;
        private static Map map;

        private ImportAsExtern(Integer value) {
            this.value = value;
        }

        public static ImportAsExtern valueOf(int importAsExtern) {
            return (ImportAsExtern)((Object)map.get(importAsExtern));
        }

        public Integer getValue() {
            return this.value;
        }

        static {
            map = new HashMap();
            for (ImportAsExtern importAsExtern : ImportAsExtern.values()) {
                map.put(importAsExtern.value, importAsExtern);
            }
        }
    }
}

