/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.wsman.utils;

import org.opennms.core.wsman.exceptions.HTTPException;
import org.opennms.core.wsman.exceptions.UnauthorizedException;
import org.opennms.core.wsman.exceptions.WSManException;

public class RetryNTimesLoop {
    private final int m_numberOfRetries;
    private int m_numberOfContinues = 0;

    public RetryNTimesLoop(int numberOfRetries) {
        if (numberOfRetries < 0) {
            throw new IllegalArgumentException("Number of retries must be positive.");
        }
        this.m_numberOfRetries = numberOfRetries;
    }

    public boolean shouldContinue() {
        boolean shouldContinue = this.m_numberOfRetries >= this.m_numberOfContinues;
        ++this.m_numberOfContinues;
        return shouldContinue;
    }

    public void takeException(WSManException e) throws WSManException {
        if (!(e instanceof HTTPException) || !(e instanceof UnauthorizedException)) {
            // empty if block
        }
        throw e;
    }
}

