/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuf slice(ByteBuf buffer, int size) {
        if (size > buffer.readableBytes()) {
            throw new BufferUnderflowException();
        }
        ByteBuf result = buffer.slice(buffer.readerIndex(), size);
        buffer.readerIndex(buffer.readerIndex() + size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R peek(ByteBuf buffer, Function<ByteBuf, R> consumer) {
        int position = buffer.readerIndex();
        try {
            R r = consumer.apply(buffer);
            return r;
        }
        finally {
            buffer.readerIndex(position);
        }
    }

    public static float sfloat(ByteBuf buffer) {
        return Float.intBitsToFloat(BufferUtils.sint32(buffer));
    }

    public static UnsignedLong uint(ByteBuf buffer, int octets) {
        Preconditions.checkArgument((0 <= octets && octets <= 8 ? 1 : 0) != 0);
        long result = 0L;
        for (int i = 0; i < octets; ++i) {
            result = result << 8 | (long)buffer.readUnsignedByte() & 0xFFL;
        }
        return UnsignedLong.fromLongBits((long)result);
    }

    public static Long sint(ByteBuf buffer, int octets) {
        boolean s;
        Preconditions.checkArgument((0 <= octets && octets <= 8 ? 1 : 0) != 0);
        long result = (long)buffer.readUnsignedByte() & 0xFFL;
        boolean bl = s = (result & 0x80L) != 0L;
        result = s ? 0xFFFFFFFFFFFFFF80L | result & 0x7FL : (result &= 0x7FL);
        for (int i = 1; i < octets; ++i) {
            result = result << 8 | (long)buffer.readUnsignedByte() & 0xFFL;
        }
        return result;
    }

    public static int uint8(ByteBuf buffer) {
        return buffer.readUnsignedByte() & 0xFF;
    }

    public static int uint16(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 8 | (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static int uint24(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 16 | (buffer.readUnsignedByte() & 0xFF) << 8 | (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static long uint32(ByteBuf buffer) {
        return ((long)buffer.readUnsignedByte() & 0xFFL) << 24 | ((long)buffer.readUnsignedByte() & 0xFFL) << 16 | ((long)buffer.readUnsignedByte() & 0xFFL) << 8 | ((long)buffer.readUnsignedByte() & 0xFFL) << 0;
    }

    public static UnsignedLong uint64(ByteBuf buffer) {
        return UnsignedLong.fromLongBits((long)(((long)buffer.readUnsignedByte() & 0xFFL) << 56 | ((long)buffer.readUnsignedByte() & 0xFFL) << 48 | ((long)buffer.readUnsignedByte() & 0xFFL) << 40 | ((long)buffer.readUnsignedByte() & 0xFFL) << 32 | ((long)buffer.readUnsignedByte() & 0xFFL) << 24 | ((long)buffer.readUnsignedByte() & 0xFFL) << 16 | ((long)buffer.readUnsignedByte() & 0xFFL) << 8 | ((long)buffer.readUnsignedByte() & 0xFFL) << 0));
    }

    public static Integer sint8(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static Integer sint16(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 8 | (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static Integer sint24(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 16 | (buffer.readUnsignedByte() & 0xFF) << 8 | (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static Integer sint32(ByteBuf buffer) {
        return (buffer.readUnsignedByte() & 0xFF) << 24 | (buffer.readUnsignedByte() & 0xFF) << 16 | (buffer.readUnsignedByte() & 0xFF) << 8 | (buffer.readUnsignedByte() & 0xFF) << 0;
    }

    public static Long sint64(ByteBuf buffer) {
        return ((long)buffer.readUnsignedByte() & 0xFFL) << 56 | ((long)buffer.readUnsignedByte() & 0xFFL) << 48 | ((long)buffer.readUnsignedByte() & 0xFFL) << 40 | ((long)buffer.readUnsignedByte() & 0xFFL) << 32 | ((long)buffer.readUnsignedByte() & 0xFFL) << 24 | ((long)buffer.readUnsignedByte() & 0xFFL) << 16 | ((long)buffer.readUnsignedByte() & 0xFFL) << 8 | ((long)buffer.readUnsignedByte() & 0xFFL) << 0;
    }

    public static byte[] bytes(ByteBuf buffer, int size) {
        byte[] result = new byte[size];
        buffer.readBytes(result);
        return result;
    }

    public static void skip(ByteBuf buffer, int size) {
        buffer.skipBytes(size);
    }

    public static <T, E extends Exception> List<T> repeatRemaining(ByteBuf buffer, Parser<T, E> parser) throws E {
        ArrayList elements = Lists.newArrayList();
        while (buffer.isReadable()) {
            elements.add(parser.parse(buffer));
        }
        return Collections.unmodifiableList(elements);
    }

    public static <T, E extends Exception> List<T> repeatCount(ByteBuf buffer, int count, Parser<T, E> parser) throws E {
        ArrayList elements = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            elements.add(parser.parse(buffer));
        }
        return Collections.unmodifiableList(elements);
    }

    @FunctionalInterface
    public static interface Parser<T, E extends Exception> {
        public T parse(ByteBuf var1) throws E;
    }
}

