/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.local.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.transaction.xa.XAResource;
import org.apache.aries.tx.control.service.common.impl.AbstractTransactionContextImpl;
import org.osgi.service.transaction.control.LocalResource;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionStatus;

public class TransactionContextImpl
extends AbstractTransactionContextImpl
implements TransactionContext {
    final List<LocalResource> resources = new ArrayList<LocalResource>();
    private final boolean readOnly;
    private boolean workBodyFinished;
    private AtomicReference<TransactionStatus> tranStatus = new AtomicReference<TransactionStatus>(TransactionStatus.ACTIVE);
    private Object txId;

    public TransactionContextImpl(Object txId, boolean readOnly) {
        this.txId = txId;
        this.readOnly = readOnly;
    }

    @Override
    public Object getTransactionKey() {
        return this.txId;
    }

    @Override
    public boolean getRollbackOnly() throws IllegalStateException {
        switch (this.tranStatus.get()) {
            case MARKED_ROLLBACK: 
            case ROLLING_BACK: 
            case ROLLED_BACK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException {
        TransactionStatus status = this.tranStatus.get();
        switch (status) {
            case MARKED_ROLLBACK: 
            case ACTIVE: {
                if (this.tranStatus.compareAndSet(status, TransactionStatus.MARKED_ROLLBACK)) break;
                this.setRollbackOnly();
                break;
            }
            case COMMITTING: {
                throw new IllegalStateException("The transaction is already being committed");
            }
            case COMMITTED: {
                throw new IllegalStateException("The transaction is already committed");
            }
            case ROLLING_BACK: 
            case ROLLED_BACK: {
                break;
            }
            default: {
                throw new IllegalStateException("The transaction is in an unkown state");
            }
        }
    }

    @Override
    protected void safeSetRollbackOnly() {
        TransactionStatus status = this.tranStatus.get();
        switch (status) {
            case MARKED_ROLLBACK: 
            case ACTIVE: {
                if (this.tranStatus.compareAndSet(status, TransactionStatus.MARKED_ROLLBACK)) break;
                this.safeSetRollbackOnly();
                break;
            }
        }
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return this.tranStatus.get();
    }

    @Override
    public void preCompletion(Runnable job) throws IllegalStateException {
        if (this.workBodyFinished) {
            throw new IllegalStateException("The current transactional work has finished executing so a pre-completion callback can no longer be registered");
        }
        this.preCompletion.add(job);
    }

    @Override
    public void postCompletion(Consumer<TransactionStatus> job) throws IllegalStateException {
        TransactionStatus status = this.tranStatus.get();
        if (status == TransactionStatus.COMMITTED || status == TransactionStatus.ROLLED_BACK) {
            throw new IllegalStateException("The current transaction is complete so a post-completion callback can no longer be registered");
        }
        this.postCompletion.add(job);
    }

    @Override
    public void registerXAResource(XAResource resource, String name) {
        throw new IllegalStateException("Not an XA manager");
    }

    @Override
    public void registerLocalResource(LocalResource resource) {
        if (this.tranStatus.get().compareTo(TransactionStatus.MARKED_ROLLBACK) > 0) {
            throw new IllegalStateException("The current transaction is in state " + this.tranStatus);
        }
        this.resources.add(resource);
    }

    @Override
    public boolean supportsXA() {
        return false;
    }

    @Override
    public boolean supportsLocal() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected boolean isAlive() {
        TransactionStatus status = this.tranStatus.get();
        return status != TransactionStatus.COMMITTED && status != TransactionStatus.ROLLED_BACK;
    }

    @Override
    public void finish() {
        TransactionStatus status;
        this.workBodyFinished = true;
        this.beforeCompletion(() -> this.setRollbackOnly());
        if (this.getRollbackOnly()) {
            this.vanillaRollback();
            status = TransactionStatus.ROLLED_BACK;
        } else {
            this.tranStatus.set(TransactionStatus.COMMITTING);
            ArrayList committed = new ArrayList(this.resources.size());
            ArrayList rolledback = new ArrayList(0);
            this.resources.stream().forEach(lr -> {
                try {
                    if (this.getRollbackOnly()) {
                        lr.rollback();
                        rolledback.add(lr);
                    } else {
                        lr.commit();
                        committed.add(lr);
                    }
                }
                catch (Exception e) {
                    this.firstUnexpectedException.compareAndSet(null, e);
                    if (committed.isEmpty()) {
                        this.tranStatus.set(TransactionStatus.ROLLING_BACK);
                    }
                    rolledback.add(lr);
                }
            });
            status = this.tranStatus.updateAndGet(ts -> ts == TransactionStatus.ROLLING_BACK ? TransactionStatus.ROLLED_BACK : TransactionStatus.COMMITTED);
        }
        this.afterCompletion(status);
    }

    private void vanillaRollback() {
        this.tranStatus.set(TransactionStatus.ROLLING_BACK);
        this.resources.stream().forEach(lr -> {
            try {
                lr.rollback();
            }
            catch (Exception e) {
                this.recordFailure(e);
            }
        });
        this.tranStatus.set(TransactionStatus.ROLLED_BACK);
    }
}

