/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistrationResolver;
import org.apache.felix.httplite.server.Connection;
import org.apache.felix.httplite.server.ThreadGate;
import org.apache.felix.httplite.server.ThreadPool;

public class Server {
    public static final String CONFIG_PROPERTY_CONNECTION_TIMEOUT_PROP = "org.apache.felix.http.connection.timeout";
    public static final String CONFIG_PROPERTY_CONNECTION_REQUESTLIMIT_PROP = "org.apache.felix.http.connection.requestlimit";
    public static final String CONFIG_PROPERTY_THREADPOOL_TIMEOUT_PROP = "org.apache.felix.http.threadpool.timeout";
    public static final String CONFIG_PROPERTY_THREADPOOL_LIMIT_PROP = "org.apache.felix.http.threadpool.limit";
    public static final String CONFIG_PROPERTY_HTTPS_ENABLE = "org.apache.felix.https.enable";
    public static final String CONFIG_PROPERTY_HTTP_ENABLE = "org.apache.felix.http.enable";
    public static final String CONFIG_PROPERTY_HTTP_PORT = "org.osgi.service.http.port";
    public static final String CONFIG_PROPERTY_HTTP_HOST = "org.apache.felix.http.host";
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_THREADPOOL_LIMIT = 10;
    public static final int INACTIVE_STATE = 0;
    public static final int ACTIVE_STATE = 1;
    public static final int STOPPING_STATE = 2;
    private String m_hostname;
    private final int m_port;
    private InetAddress m_bindAddr;
    private int m_state;
    private ThreadGate m_shutdownGate;
    private Thread m_serverThread;
    private ServerSocket m_serverSocket;
    private final ThreadPool m_threadPool;
    private final int m_connectionTimeout;
    private final int m_connectionRequestLimit;
    private ServiceRegistrationResolver m_resolver;
    private final Logger m_logger;
    private boolean m_stopping = false;

    public Server(Map configMap, Logger logger) {
        this.m_logger = logger;
        this.m_state = 0;
        configMap = configMap == null ? new HashMap() : configMap;
        this.m_port = Server.getConfiguredPort(configMap);
        this.m_bindAddr = this.getConfiguredBindAddr(configMap);
        int threadLimit = configMap.get(CONFIG_PROPERTY_THREADPOOL_LIMIT_PROP) == null ? 10 : Integer.parseInt((String)configMap.get(CONFIG_PROPERTY_THREADPOOL_LIMIT_PROP));
        int threadTimeout = configMap.get(CONFIG_PROPERTY_THREADPOOL_TIMEOUT_PROP) == null ? 60000 : Integer.parseInt((String)configMap.get(CONFIG_PROPERTY_THREADPOOL_TIMEOUT_PROP));
        this.m_threadPool = new ThreadPool(threadLimit, threadTimeout, this.m_logger);
        this.m_connectionTimeout = configMap.get(CONFIG_PROPERTY_CONNECTION_TIMEOUT_PROP) == null ? 10000 : Integer.parseInt((String)configMap.get(CONFIG_PROPERTY_CONNECTION_TIMEOUT_PROP));
        this.m_connectionRequestLimit = configMap.get(CONFIG_PROPERTY_CONNECTION_REQUESTLIMIT_PROP) == null ? 50 : Integer.parseInt((String)configMap.get(CONFIG_PROPERTY_CONNECTION_REQUESTLIMIT_PROP));
    }

    public static int getConfiguredPort(Map configMap) {
        return configMap.get(CONFIG_PROPERTY_HTTP_PORT) == null ? 8080 : Integer.parseInt((String)configMap.get(CONFIG_PROPERTY_HTTP_PORT));
    }

    public InetAddress getConfiguredBindAddr(Map configMap) {
        try {
            return configMap.get(CONFIG_PROPERTY_HTTP_HOST) == null ? null : InetAddress.getByName((String)configMap.get(CONFIG_PROPERTY_HTTP_HOST));
        }
        catch (UnknownHostException ex) {
            this.m_logger.log(1, "Unable to resolve " + configMap.get(CONFIG_PROPERTY_HTTP_HOST) + " to address of interface to bind to. Binding to all interfaces.", ex);
            return null;
        }
    }

    public synchronized int getState() {
        return this.m_state;
    }

    public synchronized String getHostname() {
        if (this.m_hostname == null) {
            try {
                this.m_hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                this.m_logger.log(1, "Unable to get hostname, setting to localhost.", ex);
                this.m_hostname = "localhost";
            }
        }
        return this.m_hostname;
    }

    public synchronized int getPort() {
        return this.m_port;
    }

    public synchronized void start(ServiceRegistrationResolver resolver) throws IOException {
        this.m_resolver = resolver;
        if (this.m_state == 0) {
            this.m_serverSocket = this.m_bindAddr == null ? new ServerSocket(this.m_port) : new ServerSocket(this.m_port, 0, this.m_bindAddr);
            this.m_serverThread = new Thread(new Runnable(){

                public void run() {
                    Server.this.acceptConnections();
                }
            }, "HttpServer");
            this.m_state = 1;
            this.m_serverThread.start();
        } else if (this.m_state == 2) {
            throw new IllegalStateException("Server is in process of stopping.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        ThreadGate gate = null;
        Server server = this;
        synchronized (server) {
            if (this.m_state != 0) {
                this.m_logger.log(3, "Shutting down, be patient...waiting for all threads to finish.");
                if (this.m_shutdownGate == null) {
                    this.m_shutdownGate = new ThreadGate();
                }
                gate = this.m_shutdownGate;
                try {
                    this.m_serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (gate != null) {
            gate.await();
        }
    }

    private void acceptConnections() {
        this.m_threadPool.start();
        this.m_logger.log(4, "Waiting for connections.");
        boolean socketConnected = true;
        while (socketConnected) {
            try {
                Socket socket = this.m_serverSocket.accept();
                try {
                    Connection connection = new Connection(socket, this.m_connectionTimeout, this.m_connectionRequestLimit, this.m_resolver, this.m_logger);
                    this.m_logger.log(4, "Accepted a new connection.");
                    this.m_threadPool.addConnection(connection);
                }
                catch (IOException ex) {
                    this.m_logger.log(1, "Error creating connection.", ex);
                }
            }
            catch (IOException ex) {
                socketConnected = false;
                if (this.m_stopping) continue;
                this.m_logger.log(1, "The call to accept() terminated with an exception.", ex);
            }
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        this.m_logger.log(4, "Waiting for thread pool threads to stop.");
        while (true) {
            try {
                this.m_threadPool.stop();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        Server server = this;
        synchronized (server) {
            this.m_shutdownGate.open();
            this.m_shutdownGate = null;
            this.m_state = 0;
        }
        this.m_logger.log(4, "Shutdown complete.");
    }

    public void setStopping() {
        this.m_stopping = true;
    }
}

