/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.newts.cli;

import com.google.common.base.Strings;
import java.io.OutputStream;
import java.util.ServiceLoader;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.newts.cli.Command;
import org.opennms.newts.cassandra.Schema;
import org.opennms.newts.cassandra.SchemaManager;

public class Init
implements Command {
    private static final ServiceLoader<Schema> s_schemas = ServiceLoader.load(Schema.class);
    @Option(name="-h", aliases={"--help"}, help=true)
    boolean showHelp = false;
    @Option(name="-p", aliases={"--print-only"}, usage="Prints the CQL statements instead of executing them.")
    boolean printOnly = false;
    @Option(name="-r", aliases={"--replication-factor"}, usage="Sets the replication factor to use when creating the keyspace.")
    int replicationFactor = 1;

    @Override
    public void execute() throws Exception {
        if (this.showHelp) {
            System.out.println("Usage: $OPENNMS_HOME/bin/newts init");
            CmdLineParser parser = new CmdLineParser((Object)new Init());
            parser.printUsage((OutputStream)System.out);
            return;
        }
        String datacenter = System.getProperty("org.opennms.newts.config.datacenter", "datacenter1");
        String keyspace = System.getProperty("org.opennms.newts.config.keyspace", "newts");
        String hostname = System.getProperty("org.opennms.newts.config.hostname", "localhost");
        int port = SystemProperties.getInteger((String)"org.opennms.newts.config.port", (int)9042);
        String username = System.getProperty("org.opennms.newts.config.username");
        String password = System.getProperty("org.opennms.newts.config.password");
        boolean ssl = Boolean.getBoolean("org.opennms.newts.config.ssl");
        String driverSettingsFile = System.getProperty("org.opennms.newts.config.driver-settings-file");
        if (!Strings.isNullOrEmpty((String)driverSettingsFile)) {
            System.out.printf("Initializing the '%s' keyspace on %s:%d%n", keyspace, hostname, port);
        } else {
            System.out.printf("Initializing the '%s' keyspace with driver settings from: %s%n", keyspace, driverSettingsFile);
        }
        try (SchemaManager m = new SchemaManager(datacenter, keyspace, hostname, port, username, password, ssl, driverSettingsFile);){
            m.setReplicationFactor(this.replicationFactor);
            for (Schema s : s_schemas) {
                m.create(s, true, this.printOnly);
            }
        }
        if (!this.printOnly) {
            System.out.println("The keyspace was successfully created.");
        }
    }
}

