/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.opennmsDataSources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;

@XmlRootElement(name="datasource-configuration")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DataSourceConfiguration
implements Serializable {
    private static final long serialVersionUID = 8984943778772781422L;
    @XmlElement(name="connection-pool")
    private ConnectionPool connectionPool;
    @XmlElement(name="jdbc-data-source", required=true)
    private List<JdbcDataSource> jdbcDataSourceList = new ArrayList<JdbcDataSource>();

    public void addJdbcDataSource(JdbcDataSource vJdbcDataSource) throws IndexOutOfBoundsException {
        this.jdbcDataSourceList.add(vJdbcDataSource);
    }

    public void addJdbcDataSource(int index, JdbcDataSource vJdbcDataSource) throws IndexOutOfBoundsException {
        this.jdbcDataSourceList.add(index, vJdbcDataSource);
    }

    public Enumeration<JdbcDataSource> enumerateJdbcDataSource() {
        return Collections.enumeration(this.jdbcDataSourceList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataSourceConfiguration) {
            DataSourceConfiguration temp = (DataSourceConfiguration)obj;
            boolean equals = Objects.equals(temp.connectionPool, this.connectionPool) && Objects.equals(temp.jdbcDataSourceList, this.jdbcDataSourceList);
            return equals;
        }
        return false;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public JdbcDataSource getJdbcDataSource(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.jdbcDataSourceList.size()) {
            throw new IndexOutOfBoundsException("getJdbcDataSource: Index value '" + index + "' not in range [0.." + (this.jdbcDataSourceList.size() - 1) + "]");
        }
        return this.jdbcDataSourceList.get(index);
    }

    public JdbcDataSource[] getJdbcDataSource() {
        JdbcDataSource[] array = new JdbcDataSource[]{};
        return this.jdbcDataSourceList.toArray(array);
    }

    public List<JdbcDataSource> getJdbcDataSourceCollection() {
        return this.jdbcDataSourceList;
    }

    public int getJdbcDataSourceCount() {
        return this.jdbcDataSourceList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.connectionPool, this.jdbcDataSourceList);
        return hash;
    }

    public Iterator<JdbcDataSource> iterateJdbcDataSource() {
        return this.jdbcDataSourceList.iterator();
    }

    public void removeAllJdbcDataSource() {
        this.jdbcDataSourceList.clear();
    }

    public boolean removeJdbcDataSource(JdbcDataSource vJdbcDataSource) {
        boolean removed = this.jdbcDataSourceList.remove(vJdbcDataSource);
        return removed;
    }

    public JdbcDataSource removeJdbcDataSourceAt(int index) {
        JdbcDataSource obj = this.jdbcDataSourceList.remove(index);
        return obj;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setJdbcDataSource(int index, JdbcDataSource vJdbcDataSource) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.jdbcDataSourceList.size()) {
            throw new IndexOutOfBoundsException("setJdbcDataSource: Index value '" + index + "' not in range [0.." + (this.jdbcDataSourceList.size() - 1) + "]");
        }
        this.jdbcDataSourceList.set(index, vJdbcDataSource);
    }

    public void setJdbcDataSource(JdbcDataSource[] vJdbcDataSourceArray) {
        this.jdbcDataSourceList.clear();
        for (int i = 0; i < vJdbcDataSourceArray.length; ++i) {
            this.jdbcDataSourceList.add(vJdbcDataSourceArray[i]);
        }
    }

    public void setJdbcDataSource(List<JdbcDataSource> vJdbcDataSourceList) {
        this.jdbcDataSourceList.clear();
        this.jdbcDataSourceList.addAll(vJdbcDataSourceList);
    }

    public void setJdbcDataSourceCollection(List<JdbcDataSource> jdbcDataSourceList) {
        this.jdbcDataSourceList = jdbcDataSourceList;
    }
}

