/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.SubNetwork;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTopologyServiceImpl
extends TopologyServiceImpl
implements NodeTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyServiceImpl.class);
    private NodeDao m_nodeDao;

    public List<Node> findAllSnmpNode() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(List.of(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.snmpPrimary", (Object)Character.valueOf(PrimaryType.PRIMARY.getCharCode())));
        for (OnmsNode node : this.m_nodeDao.findMatching(criteria)) {
            nodes.add(new Node(node.getId().intValue(), node.getLabel(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName()));
        }
        return nodes;
    }

    public Set<SubNetwork> findAllLegalSubNetwork() {
        return this.findAllSubNetwork().stream().filter(s -> !s.hasDuplicatedAddress()).filter(s -> !InetAddressUtils.inSameNetwork((InetAddress)s.getNetwork(), (InetAddress)InetAddress.getLoopbackAddress(), (InetAddress)s.getNetmask())).collect(Collectors.toSet());
    }

    public Set<SubNetwork> findSubNetworkByNetworkPrefixLessThen(int ipv4prefix, int ipv6prefix) {
        return this.findAllLegalSubNetwork().stream().filter(s -> s.isIpV4Subnetwork() && s.getNetworkPrefix() < ipv4prefix || !s.isIpV4Subnetwork() && s.getNetworkPrefix() < ipv6prefix).collect(Collectors.toSet());
    }

    public Set<SubNetwork> findAllPointToPointSubNetwork() {
        return this.findAllSubNetwork().stream().filter(s -> InetAddressUtils.isPointToPointMask((InetAddress)s.getNetmask())).collect(Collectors.toSet());
    }

    public Set<SubNetwork> findAllLegalPointToPointSubNetwork() {
        return this.findAllLegalSubNetwork().stream().filter(s -> InetAddressUtils.isPointToPointMask((InetAddress)s.getNetmask()) && s.getNodeIds().size() == 2).collect(Collectors.toSet());
    }

    public Set<SubNetwork> findAllLoopbacks() {
        return this.findAllSubNetwork().stream().filter(s -> InetAddressUtils.isLoopbackMask((InetAddress)s.getNetmask())).collect(Collectors.toSet());
    }

    public Set<SubNetwork> findAllLegalLoopbacks() {
        return this.findAllSubNetwork().stream().filter(s -> InetAddressUtils.isLoopbackMask((InetAddress)s.getNetmask()) && s.getNodeIds().size() == 1).collect(Collectors.toSet());
    }

    private static SubNetwork getNextSubnetwork(Set<SubNetwork> subNetworks) {
        SubNetwork starting = null;
        for (SubNetwork subnet : subNetworks) {
            if (starting == null) {
                starting = subnet;
                continue;
            }
            if (starting.getNodeIds().size() < subnet.getNodeIds().size()) {
                starting = subnet;
                continue;
            }
            if (starting.getNodeIds().size() != subnet.getNodeIds().size() || InetAddressUtils.difference((InetAddress)starting.getNetwork(), (InetAddress)subnet.getNetwork()).signum() <= 0) continue;
            starting = subnet;
        }
        return starting;
    }

    private int getConnected(SubNetwork starting, Set<SubNetwork> subnetworks, Map<Integer, Integer> priorityMap, int priority) {
        HashSet<SubNetwork> downlevels = new HashSet<SubNetwork>();
        for (SubNetwork subnet : subnetworks) {
            HashSet intersection = new HashSet(subnet.getNodeIds());
            intersection.retainAll(starting.getNodeIds());
            if (intersection.size() <= 0) continue;
            LOG.info("getConnected: match: {}, {} {}", new Object[]{intersection, subnet, starting});
            downlevels.add(subnet);
        }
        downlevels.forEach(subnetworks::remove);
        LOG.info("getConnected subnetworks.size: {}", (Object)subnetworks.size());
        for (SubNetwork subnetowrk : downlevels) {
            LOG.info("getConnected: parsing: {}", (Object)subnetowrk);
            LOG.info("getConnected: priority: {}", (Object)priority);
            HashSet addingNodes = new HashSet(subnetowrk.getNodeIds());
            addingNodes.removeAll(priorityMap.keySet());
            LOG.info("getConnected: adding: {}", addingNodes);
            if (addingNodes.isEmpty()) continue;
            for (Integer nodeid : addingNodes) {
                priorityMap.put(nodeid, priority);
            }
            LOG.info("getConnected: priorityMap: {}", priorityMap);
            ++priority;
        }
        if (!downlevels.isEmpty() && subnetworks.size() > 0) {
            for (SubNetwork level : downlevels) {
                LOG.info("getConnected: iterating on: " + level);
                priority = this.getConnected(level, subnetworks, priorityMap, priority);
            }
        }
        return priority;
    }

    public Map<Integer, Integer> getNodeidPriorityMap(ProtocolSupported protocol) {
        HashMap<Integer, Integer> priorityMap = new HashMap<Integer, Integer>();
        Set<SubNetwork> allLegalSubnets = this.findAllLegalSubNetwork().stream().filter(s -> s.getNodeIds().size() > 1).collect(Collectors.toSet());
        LOG.info("getNodeidPriorityMap: subnetworks.size: {}", (Object)allLegalSubnets.size());
        int priority = 0;
        int loop = 0;
        while (!allLegalSubnets.isEmpty()) {
            ++loop;
            SubNetwork start = NodeTopologyServiceImpl.getNextSubnetwork(allLegalSubnets);
            if (start == null) {
                LOG.warn("List of legal subnets isn't completely processed, but we were unable to match next subnetwork. Stopping processing. remainder={}", allLegalSubnets);
                break;
            }
            allLegalSubnets.remove(start);
            LOG.info("getNodeidPriorityMap: loop-{}: start: {}", (Object)loop, (Object)start);
            LOG.info("getNodeidPriorityMap: loop-{}: priority: {}", (Object)loop, (Object)priority);
            LOG.info("getNodeidPriorityMap: loop-{}: subnetworks.size: {}", (Object)loop, (Object)allLegalSubnets.size());
            int p = priority++;
            start.getNodeIds().forEach(n -> priorityMap.put((Integer)n, p));
            LOG.info("getNodeidPriorityMap: loop-{}: priorityMap: {}", (Object)loop, priorityMap);
            priority = this.getConnected(start, allLegalSubnets, priorityMap, priority);
        }
        return priorityMap;
    }

    public Set<SubNetwork> findAllSubNetwork() {
        HashSet<SubNetwork> subnets = new HashSet<SubNetwork>();
        List<IpInterfaceTopologyEntity> ips = this.findAllIp();
        ips.stream().filter(ip -> ip.isManaged() && ip.getNetMask() != null).forEach(ip -> {
            boolean found = false;
            for (SubNetwork s : subnets) {
                if (!s.isInRange(ip.getIpAddress()) || !s.getNetmask().equals(ip.getNetMask())) continue;
                found = true;
                s.add(ip.getNodeId(), ip.getIpAddress());
                break;
            }
            if (!found) {
                subnets.add(SubNetwork.createSubNetwork((IpInterfaceTopologyEntity)ip));
            }
        });
        ips.stream().filter(ip -> ip.isManaged() && ip.getNetMask() == null).forEach(ip -> {
            for (SubNetwork s : subnets) {
                if (!s.isInRange(ip.getIpAddress())) continue;
                s.add(ip.getNodeId(), ip.getIpAddress());
            }
        });
        return subnets;
    }

    public Node getSnmpNode(String nodeCriteria) {
        LOG.info("getSnmpNode: nodeCriteria {}", (Object)nodeCriteria);
        try {
            return this.getSnmpNode(Integer.parseInt(nodeCriteria));
        }
        catch (NumberFormatException e) {
            LOG.info("getSnmpNode: not nodeId");
            String[] values = nodeCriteria.split(":");
            LOG.info("getSnmpNode: foreignSource: {}, foreignId: {} ", (Object)values[0], (Object)values[1]);
            Criteria criteria = new Criteria(OnmsNode.class);
            criteria.setAliases(List.of(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
            criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
            criteria.addRestriction((Restriction)new EqRestriction("iface.snmpPrimary", (Object)Character.valueOf(PrimaryType.PRIMARY.getCharCode())));
            criteria.addRestriction((Restriction)new EqRestriction("foreignId", (Object)values[1]));
            criteria.addRestriction((Restriction)new EqRestriction("foreignSource", (Object)values[0]));
            return this.getNodebyCriteria(criteria);
        }
    }

    private Node getNodebyCriteria(Criteria criteria) {
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return new Node(node.getId().intValue(), node.getLabel(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName());
        }
        return null;
    }

    public Node getSnmpNode(int nodeid) {
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(List.of(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.snmpPrimary", (Object)Character.valueOf(PrimaryType.PRIMARY.getCharCode())));
        criteria.addRestriction((Restriction)new EqRestriction("id", (Object)nodeid));
        return this.getNodebyCriteria(criteria);
    }

    public Set<SubNetwork> getLegalSubNetworks(int nodeid) {
        return this.findAllLegalSubNetwork().stream().filter(s -> s.getNodeIds().contains(nodeid)).collect(Collectors.toSet());
    }

    public Set<SubNetwork> getSubNetworks(int nodeid) {
        return this.findAllSubNetwork().stream().filter(s -> s.getNodeIds().contains(nodeid)).collect(Collectors.toSet());
    }

    public List<NodeTopologyEntity> findAllNode() {
        return this.getTopologyEntityCache().getNodeTopologyEntities();
    }

    public List<IpInterfaceTopologyEntity> findAllIp() {
        return this.getTopologyEntityCache().getIpInterfaceTopologyEntities();
    }

    public List<SnmpInterfaceTopologyEntity> findAllSnmp() {
        return this.getTopologyEntityCache().getSnmpInterfaceTopologyEntities();
    }

    public NodeTopologyEntity getDefaultFocusPoint() {
        OnmsNode node = this.m_nodeDao.getDefaultFocusPoint();
        if (node != null) {
            return NodeTopologyEntity.toNodeTopologyInfo((OnmsNode)node);
        }
        return null;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }
}

