/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="service")
@ValidateUsing(value="service-configuration.xsd")
public class Service
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="enabled")
    private Boolean m_enabled;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="class-name", required=true)
    private String m_className;
    @XmlElement(name="attribute")
    private List<Attribute> m_attributes = new ArrayList<Attribute>();
    @XmlElement(name="invoke")
    private List<Invoke> m_invokes = new ArrayList<Invoke>();

    public Service() {
    }

    public Service(String name, String className, List<Attribute> attributes, List<Invoke> invokes) {
        this.setName(name);
        this.setClassName(className);
        this.setAttributes(attributes);
        this.setInvokes(invokes);
    }

    @XmlTransient
    public Boolean isEnabled() {
        return this.m_enabled == null ? Boolean.TRUE : this.m_enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    @XmlTransient
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    @XmlTransient
    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = ConfigUtils.assertNotEmpty(className, "class-name");
    }

    @XmlTransient
    public List<Attribute> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        if (attributes == this.m_attributes) {
            return;
        }
        this.m_attributes.clear();
        if (attributes != null) {
            this.m_attributes.addAll(attributes);
        }
    }

    public void addAttribute(Attribute attribute) {
        this.m_attributes.add(attribute);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.m_attributes.remove(attribute);
    }

    @XmlTransient
    public List<Invoke> getInvokes() {
        return this.m_invokes;
    }

    public void setInvokes(List<Invoke> invokes) {
        if (invokes == this.m_invokes) {
            return;
        }
        this.m_invokes.clear();
        if (invokes != null) {
            this.m_invokes.addAll(invokes);
        }
    }

    public void addInvoke(Invoke invoke) {
        this.m_invokes.add(invoke);
    }

    public boolean removeInvoke(Invoke invoke) {
        return this.m_invokes.remove(invoke);
    }

    public int hashCode() {
        return Objects.hash(this.m_enabled, this.m_name, this.m_className, this.m_attributes, this.m_invokes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Service) {
            Service that = (Service)obj;
            return Objects.equals(this.m_enabled, that.m_enabled) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_className, that.m_className) && Objects.equals(this.m_attributes, that.m_attributes) && Objects.equals(this.m_invokes, that.m_invokes);
        }
        return false;
    }
}

