/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filter;

import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.filter.JdbcFilterDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;

public class FilterDaoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FilterDaoFactory.class);
    private static FilterDao m_filterDao;

    private FilterDaoFactory() {
    }

    public static FilterDao getInstance() {
        if (m_filterDao == null) {
            FilterDaoFactory.init();
        }
        return m_filterDao;
    }

    public static void setInstance(FilterDao filterDao) {
        LOG.debug("setInstance({})", (Object)filterDao);
        m_filterDao = filterDao;
    }

    protected static synchronized void init() {
        if (m_filterDao != null) {
            return;
        }
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource(DataSourceFactory.getInstance());
        try {
            DatabaseSchemaConfigFactory.init();
        }
        catch (Throwable e) {
            throw new DataAccessResourceFailureException("Could not initialize DatabaseSchemaConfigFactory: " + e, e);
        }
        jdbcFilterDao.setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance(jdbcFilterDao);
    }
}

