/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemInfoUtils.class);
    public static final String OPENNMS_INSTANCE_ID_SYS_PROP = "org.opennms.instance.id";
    public static final String DEFAULT_INSTANCE_ID = "OpenNMS";
    private static final String s_instanceId = System.getProperty("org.opennms.instance.id", "OpenNMS");
    private static final String s_displayVersion = System.getProperty("version.display", "");
    private static final String s_version;
    private static String s_packageName;
    private static String s_packageDescription;

    public static String getInstanceId() {
        return s_instanceId;
    }

    public String getVersion() {
        return s_version;
    }

    public String getDisplayVersion() {
        return s_displayVersion;
    }

    public String getPackageName() {
        return s_packageName;
    }

    public String getPackageDescription() {
        return s_packageDescription;
    }

    static {
        Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*?$");
        Matcher m = versionPattern.matcher(s_displayVersion);
        s_version = m.matches() ? m.group(1) : s_displayVersion;
        InputStream installerProperties = SystemInfoUtils.class.getResourceAsStream("/installer.properties");
        if (installerProperties != null) {
            Properties props = new Properties();
            try {
                props.load(installerProperties);
                installerProperties.close();
                s_packageName = (String)props.get("install.package.name");
                s_packageDescription = (String)props.get("install.package.description");
            }
            catch (IOException e) {
                LOG.info("Unable to read from installer.properties in the classpath.", (Throwable)e);
            }
        }
    }
}

