/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.tag;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.tag.ColumnTag;
import org.extremecomponents.table.tag.TableTag;
import org.extremecomponents.util.ExceptionUtils;

public final class TagUtils {
    private static Log logger = LogFactory.getLog(ColumnTag.class);

    private TagUtils() {
    }

    public static final String evaluateExpressionAsString(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        try {
            if (attribute != null) {
                attribute = (String)ExpressionEvaluatorManager.evaluate((String)attributeName, (String)attribute, String.class, (Tag)tag, (PageContext)pageContext);
            }
        }
        catch (JspException e) {
            logger.error((Object)("Could not resolve EL for [" + attributeName + "] - " + ExceptionUtils.formatStackTrace(e)));
        }
        return attribute;
    }

    public static final Object evaluateExpressionAsObject(String attributeName, Object attribute, Tag tag, PageContext pageContext) {
        try {
            if (attribute != null) {
                attribute = ExpressionEvaluatorManager.evaluate((String)attributeName, (String)attribute.toString(), Object.class, (Tag)tag, (PageContext)pageContext);
            }
        }
        catch (JspException e) {
            logger.error((Object)("Could not resolve EL for [" + attributeName + "] - " + ExceptionUtils.formatStackTrace(e)));
        }
        return attribute;
    }

    public static final Collection evaluateExpressionAsCollection(String attributeName, Object attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsObject(attributeName, attribute, tag, pageContext)) == null || !(attribute instanceof Collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The attribute [" + attributeName + "] is null or not a Collection."));
            }
            return null;
        }
        return (Collection)attribute;
    }

    public static final Boolean evaluateExpressionAsBoolean(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsString(attributeName, attribute, tag, pageContext)) == null) {
            return null;
        }
        return Boolean.valueOf(attribute);
    }

    public static final int evaluateExpressionAsInt(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsString(attributeName, attribute, tag, pageContext)) == null) {
            return 0;
        }
        return new Integer(attribute);
    }

    public static TableModel getModel(Tag tag) {
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)tag, TableTag.class);
        return tableTag.getModel();
    }

    public static boolean isIteratingBody(Tag tag) {
        return TagUtils.getModel(tag).getCurrentRowBean() != null;
    }
}

