/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.callback;

import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NullSafeBeanComparator<T>
extends BeanComparator<T> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NullSafeBeanComparator.class);
    protected boolean nullsAreHigh = true;
    protected String property;
    protected transient Comparator<T> comparator;

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public boolean isNullsAreHigh() {
        return this.nullsAreHigh;
    }

    public void setNullsAreHigh(boolean nullsAreHigh) {
        this.nullsAreHigh = nullsAreHigh;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public int compare(T o1, T o2) {
        if (this.property == null) {
            return this.comparator.compare(o1, o2);
        }
        Object val1 = null;
        Object val2 = null;
        try {
            try {
                val1 = PropertyUtils.getProperty(o1, (String)this.property);
            }
            catch (NestedNullException nestedNullException) {
                // empty catch block
            }
            try {
                val2 = PropertyUtils.getProperty(o2, (String)this.property);
            }
            catch (NestedNullException nestedNullException) {
                // empty catch block
            }
            if (val1 == val2) {
                return 0;
            }
            if (val1 == null) {
                return this.nullsAreHigh ? 1 : -1;
            }
            if (val2 == null) {
                return this.nullsAreHigh ? -1 : 1;
            }
            return this.comparator.compare(val1, val2);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return 0;
        }
    }

    public NullSafeBeanComparator(String property, Comparator<T> c) {
        this.comparator = c;
        this.property = property;
    }

    public NullSafeBeanComparator(String property, Comparator<T> c, boolean nullAreHigh) {
        this.comparator = c;
        this.property = property;
        this.nullsAreHigh = nullAreHigh;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.comparator, this.nullsAreHigh, this.property);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NullSafeBeanComparator other = (NullSafeBeanComparator)((Object)obj);
        return Objects.equals(this.comparator, other.comparator) && this.nullsAreHigh == other.nullsAreHigh && Objects.equals(this.property, other.property);
    }
}

