/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class GPath<O> {
    private final Function<JsonElement, O> eval;

    public static GPath<String> string() {
        return new GPath<String>(JsonElement::getAsString);
    }

    public static GPath<Double> dbl() {
        return new GPath<Double>(JsonElement::getAsDouble);
    }

    public static GPath<Integer> integer() {
        return new GPath<Integer>(JsonElement::getAsInt);
    }

    public static GPath<JsonElement> any() {
        return new GPath<JsonElement>(je -> je);
    }

    public static GPath<JsonObject> object() {
        return new GPath<JsonObject>(JsonElement::getAsJsonObject);
    }

    public static GPath<JsonArray> array() {
        return new GPath<JsonArray>(JsonElement::getAsJsonArray);
    }

    public static <X> GPath<X> field(String name, GPath<X> path) {
        return path.field(name);
    }

    public static <X> GPath<X> field(String name, String altName, GPath<X> path) {
        return path.field(name, altName);
    }

    public static <X> GPath<List<X>> array(String name, GPath<X> path) {
        return path.array(name);
    }

    public GPath(Function<JsonElement, O> eval) {
        this.eval = eval;
    }

    public GPath<O> field(String name) {
        return this.field(name, name);
    }

    public GPath<O> field(String name, String altName) {
        return new GPath<Object>(je -> {
            if (je.isJsonObject()) {
                JsonElement j2;
                JsonObject jo = je.getAsJsonObject();
                JsonElement j = jo.get(name);
                JsonElement jsonElement = j2 = j != null ? j : jo.get(altName);
                if (j2 != null) {
                    return this.eval(j2);
                }
            }
            return null;
        });
    }

    public GPath<List<O>> array(String name) {
        return new GPath<List<O>>(je -> {
            JsonArray array;
            JsonElement j;
            if (je.isJsonObject() && (j = je.getAsJsonObject().get(name)) != null && j.isJsonArray() && (array = j.getAsJsonArray()) != null) {
                ArrayList list = new ArrayList();
                array.forEach(i -> list.add(this.eval((JsonElement)i)));
                return list;
            }
            return null;
        });
    }

    public <X> GPath<X> map(Function<O, X> f) {
        return new GPath<Object>(je -> {
            O o = this.eval((JsonElement)je);
            return o != null ? f.apply(o) : null;
        });
    }

    public O eval(JsonElement in) {
        return this.eval.apply(in);
    }
}

