/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.search;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.search.SearchContext;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.api.search.SearchProvider;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.model.OnmsNode;

public class NodeSearchProvider
implements SearchProvider {
    protected static final String CONTEXT = "Node";
    private final NodeDao nodeDao;

    public NodeSearchProvider(NodeDao nodeDao) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public boolean canSuggest(GraphService graphService, String namespace) {
        return true;
    }

    public List<SearchSuggestion> getSuggestions(SearchContext searchContext, String namespace, String input) {
        Criteria criteria = new CriteriaBuilder(OnmsNode.class).ilike("label", (Object)("%" + input + "%")).orderBy("label", true).limit(Integer.valueOf(searchContext.getSuggestionsLimit())).toCriteria();
        List matchingNodes = this.nodeDao.findMatching(criteria);
        ArrayList suggestions = Lists.newArrayList();
        for (OnmsNode eachNode : matchingNodes) {
            SearchSuggestion suggestion = new SearchSuggestion(this.getProviderId(), CONTEXT, Integer.toString(eachNode.getId()), eachNode.getLabel());
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    public List<GenericVertex> resolve(GraphService graphService, SearchCriteria searchCriteria) {
        OnmsNode node = this.nodeDao.get(searchCriteria.getCriteria());
        NodeRef nodeRef = NodeRef.from((int)node.getId(), (String)node.getForeignSource(), (String)node.getForeignId());
        List vertices = graphService.getGraph(searchCriteria.getNamespace()).resolveVertices(nodeRef);
        return vertices;
    }
}

