/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.collectors;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.apilayer.common.collectors.ServiceCollectorImpl;
import org.opennms.features.apilayer.common.utils.InterfaceMapper;
import org.opennms.integration.api.v1.collectors.ServiceCollectorFactory;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.osgi.framework.BundleContext;

public class ServiceCollectorManager
extends InterfaceMapper<ServiceCollectorFactory, ServiceCollector> {
    private final int rrdStep;
    private final int rrdHeartBeat;
    private final String rrdRraStr;

    public ServiceCollectorManager(BundleContext bundleContext, int rrdStep, int rrdHeartBeat, String rrdRrsStr) {
        super(ServiceCollector.class, bundleContext);
        this.rrdStep = rrdStep;
        this.rrdHeartBeat = rrdHeartBeat;
        this.rrdRraStr = rrdRrsStr;
    }

    @Override
    public ServiceCollector map(ServiceCollectorFactory ext) {
        RrdRepository rrdRepository = new RrdRepository();
        rrdRepository.setStep(this.rrdStep);
        rrdRepository.setHeartBeat(this.rrdHeartBeat);
        rrdRepository.setRraList(Arrays.asList(this.rrdRraStr.split(",")));
        rrdRepository.setRrdBaseDir(new File(ResourceTypeUtils.DEFAULT_RRD_ROOT, "snmp"));
        return new ServiceCollectorImpl(ext, rrdRepository);
    }

    @Override
    public Map<String, Object> getServiceProperties(ServiceCollectorFactory extension) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("type", extension.getCollectorClassName());
        return properties;
    }
}

