/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.telemetry.api.TelemetryManager;
import org.opennms.netmgt.telemetry.api.adapter.Adapter;
import org.opennms.netmgt.telemetry.api.receiver.GracefulShutdownListener;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.common.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.config.dao.TelemetrydConfigDao;
import org.opennms.netmgt.telemetry.config.model.AdapterConfig;
import org.opennms.netmgt.telemetry.config.model.ListenerConfig;
import org.opennms.netmgt.telemetry.config.model.QueueConfig;
import org.opennms.netmgt.telemetry.config.model.TelemetrydConfig;
import org.opennms.netmgt.telemetry.daemon.ConnectorManager;
import org.opennms.netmgt.telemetry.daemon.TelemetryMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

@EventListener(name="Telemetryd", logPrefix="telemetryd")
public class Telemetryd
implements SpringServiceDaemon,
TelemetryManager {
    private static final Logger LOG = LoggerFactory.getLogger(Telemetryd.class);
    public static final String NAME = "Telemetryd";
    public static final String LOG_PREFIX = "telemetryd";
    @Autowired
    private TelemetrydConfigDao telemetrydConfigDao;
    @Autowired
    private MessageDispatcherFactory messageDispatcherFactory;
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TelemetryRegistry telemetryRegistry;
    @Autowired
    private ConnectorManager connectorManager;
    private List<TelemetryMessageConsumer> consumers = new ArrayList<TelemetryMessageConsumer>();
    private List<Listener> listeners = new ArrayList<Listener>();

    public synchronized void start() throws Exception {
        if (this.consumers.size() > 0) {
            throw new IllegalStateException("Telemetryd is already started.");
        }
        LOG.info("{} is starting.", (Object)NAME);
        TelemetrydConfig config = (TelemetrydConfig)this.telemetrydConfigDao.getContainer().getObject();
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        for (QueueConfig queueConfig : config.getQueues()) {
            TelemetrySinkModule sinkModule = new TelemetrySinkModule((QueueDefinition)queueConfig);
            beanFactory.autowireBean((Object)sinkModule);
            beanFactory.initializeBean((Object)sinkModule, "sinkModule");
            List enabledAdapters = queueConfig.getAdapters().stream().filter(AdapterConfig::isEnabled).collect(Collectors.toList());
            if (!enabledAdapters.isEmpty()) {
                TelemetryMessageConsumer consumer = new TelemetryMessageConsumer((QueueDefinition)queueConfig, enabledAdapters, sinkModule);
                beanFactory.autowireBean((Object)consumer);
                beanFactory.initializeBean((Object)consumer, "consumer");
                this.consumers.add(consumer);
            } else {
                LOG.debug("Skipping consumer for queue: {} (no adapters enabled/defined)", (Object)queueConfig.getName());
            }
            AsyncDispatcher dispatcher = this.messageDispatcherFactory.createAsyncDispatcher((SinkModule)sinkModule);
            this.telemetryRegistry.registerDispatcher(queueConfig.getName(), dispatcher);
        }
        for (ListenerConfig listenerConfig : config.getListeners()) {
            if (!listenerConfig.isEnabled()) {
                LOG.debug("Skipping disabled listener: {}", (Object)listenerConfig.getName());
                continue;
            }
            if (listenerConfig.getParsers().isEmpty()) {
                LOG.debug("Skipping listener with no parsers: {}", (Object)listenerConfig.getName());
                continue;
            }
            Listener listener = this.telemetryRegistry.getListener((ListenerDefinition)listenerConfig);
            if (listener == null) {
                throw new IllegalStateException("Failed to create listener from registry for listener named: " + listenerConfig.getName());
            }
            this.listeners.add(listener);
        }
        for (TelemetryMessageConsumer consumer : this.consumers) {
            LOG.info("Starting consumer for {} adapter.", (Object)consumer.getQueue().getName());
            this.messageConsumerManager.registerConsumer((MessageConsumer)consumer);
        }
        for (Listener listener : this.listeners) {
            LOG.info("Starting {} listener.", (Object)listener.getName());
            listener.start();
        }
        if (!config.getConnectors().isEmpty()) {
            LOG.info("Starting connectors.");
            this.connectorManager.start(config);
        }
        LOG.info("{} is started.", (Object)NAME);
    }

    public synchronized void destroy() {
        LOG.info("{} is stopping.", (Object)NAME);
        ArrayList stopFutures = new ArrayList();
        for (Listener listener : this.listeners) {
            try {
                LOG.info("Stopping {} listener.", (Object)listener.getName());
                listener.stop();
                if (!(listener instanceof GracefulShutdownListener)) continue;
                Future future = ((GracefulShutdownListener)listener).getShutdownFuture();
                if (future == null) {
                    LOG.warn("Shutdown future is missing for {}.", (Object)listener.getName());
                    continue;
                }
                stopFutures.add(future);
            }
            catch (InterruptedException e) {
                LOG.warn("Error while stopping listener.", (Throwable)e);
            }
        }
        this.listeners.clear();
        try {
            this.waitForStop(stopFutures, SystemProperties.getInteger((String)"org.opennms.features.telemetry.shutdownTimeout", (int)60));
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Error while waiting stop future.", (Throwable)e);
        }
        LOG.info("Stopping connectors.");
        this.connectorManager.stop();
        for (AsyncDispatcher dispatcher : this.telemetryRegistry.getDispatchers()) {
            try {
                LOG.info("Closing dispatcher: {}", (Object)dispatcher);
                dispatcher.close();
            }
            catch (Exception e) {
                LOG.warn("Error while closing dispatcher.", (Throwable)e);
            }
        }
        this.telemetryRegistry.clearDispatchers();
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        for (TelemetryMessageConsumer consumer : this.consumers) {
            try {
                LOG.info("Stopping consumer for {} protocol.", (Object)consumer.getQueue().getName());
                this.messageConsumerManager.unregisterConsumer((MessageConsumer)consumer);
            }
            catch (Exception e) {
                LOG.error("Error while stopping consumer.", (Throwable)e);
            }
            beanFactory.destroyBean((Object)consumer);
        }
        this.consumers.clear();
        LOG.info("{} is stopped.", (Object)NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStop(List<Future<?>> futures, int maxTime) throws ExecutionException, InterruptedException {
        Object lock;
        Objects.requireNonNull(futures);
        Object object = lock = new Object();
        synchronized (object) {
            for (int i = 0; i < maxTime; ++i) {
                boolean allDone = true;
                for (Future<?> future : futures) {
                    if (future.isDone()) continue;
                    allDone = false;
                    break;
                }
                if (allDone) {
                    if (LOG.isInfoEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        for (Future<?> future : futures) {
                            builder.append(future.get());
                            builder.append(" ");
                        }
                        LOG.info("Future done time: {}s output: {}", (Object)i, (Object)builder);
                    }
                    return;
                }
                lock.wait(1000L);
            }
            LOG.warn("Fail to wait for stop future. Futures: {} maxTime: {}", futures, (Object)maxTime);
        }
    }

    public void afterPropertiesSet() {
    }

    private synchronized void handleConfigurationChanged() {
        this.destroy();
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(IEvent e) {
        DaemonTools.handleReloadEvent((IEvent)e, (String)NAME, event -> this.handleConfigurationChanged());
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public List<Adapter> getAdapters() {
        return this.consumers.stream().flatMap(consumer -> consumer.getAdapters().stream()).collect(Collectors.toList());
    }
}

