/*
 * Decompiled with CFR 0.152.
 */
package org.openbmp.api.parsed.message;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

public abstract class Base {
    private final Float DEFAULT_SPEC_VERSION = new Float(1.7);
    protected Float spec_version;
    protected String[] headerNames = null;
    protected List<Map<String, Object>> rowMap;
    private final Logger logger = LoggerFactory.getLogger(Base.class);

    protected Base() {
        this.rowMap = new ArrayList<Map<String, Object>>();
        this.spec_version = this.DEFAULT_SPEC_VERSION;
    }

    public boolean parse(String data) {
        return this.parse(this.DEFAULT_SPEC_VERSION, data);
    }

    public boolean parse(Float version, String data) {
        this.spec_version = version;
        CellProcessor[] processors = this.getProcessors();
        CsvMapReader mapReader = null;
        try {
            mapReader = new CsvMapReader((Reader)new StringReader(data), CsvPreference.TAB_PREFERENCE);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        if (mapReader == null) {
            return true;
        }
        try {
            Map map;
            if (this.headerNames.length != processors.length) {
                ArrayList<String> headerList = new ArrayList<String>();
                headerList.addAll(Arrays.asList(this.headerNames));
                this.headerNames = headerList.subList(0, processors.length).toArray(new String[processors.length]);
            }
            while ((map = mapReader.read(this.headerNames, processors)) != null) {
                this.rowMap.add(map);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        catch (SuperCsvException e) {
            e.printStackTrace();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    protected abstract CellProcessor[] getProcessors();

    public List<Map<String, Object>> getRowMap() {
        return this.rowMap;
    }
}

