/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPIntermediateResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.BinderyObjectEventData;
import com.novell.ldap.events.edir.eventdata.ChangeAddressEventData;
import com.novell.ldap.events.edir.eventdata.ConnectionStateEventData;
import com.novell.ldap.events.edir.eventdata.DebugEventData;
import com.novell.ldap.events.edir.eventdata.EntryEventData;
import com.novell.ldap.events.edir.eventdata.GeneralDSEventData;
import com.novell.ldap.events.edir.eventdata.ModuleStateEventData;
import com.novell.ldap.events.edir.eventdata.NetworkAddressEventData;
import com.novell.ldap.events.edir.eventdata.SecurityEquivalenceEventData;
import com.novell.ldap.events.edir.eventdata.ValueEventData;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class EdirEventIntermediateResponse
extends LDAPIntermediateResponse {
    private static final int EDIR_TAG_ENTRY_EVENT_DATA = 1;
    private static final int EDIR_TAG_VALUE_EVENT_DATA = 2;
    private static final int EDIR_TAG_GENERAL_EVENT_DATA = 3;
    private static final int EDIR_TAG_SKULK_DATA = 4;
    private static final int EDIR_TAG_BINDERY_EVENT_DATA = 5;
    private static final int EDIR_TAG_DSESEV_INFO = 6;
    private static final int EDIR_TAG_MODULE_STATE_DATA = 7;
    private static final int EDIR_TAG_NETWORK_ADDRESS = 8;
    private static final int EDIR_TAG_CONNECTION_STATE = 9;
    private static final int EDIR_TAG_CHANGE_SERVER_ADDRESS = 12;
    private static final int EDIR_TAG_CHANGE_CONFIG_PARAM = 13;
    private static final int EDIR_TAG_NO_DATA = 14;
    private static final int EDIR_TAG_STATUS_LOG = 15;
    private static final int EDIR_TAG_DEBUG_EVENT_DATA = 16;
    private int eventtype;
    private int eventResult;
    private EventResponseData responsedata;

    public EdirEventIntermediateResponse(RfcLDAPMessage rfcLDAPMessage) throws LDAPException {
        super(rfcLDAPMessage);
        try {
            byte[] byArray = this.getValue();
            this.processmessage(byArray);
        }
        catch (IOException iOException) {
            throw new LDAPException("DECODING_ERROR", 84, iOException.getMessage());
        }
    }

    public EdirEventIntermediateResponse(byte[] byArray) throws Exception {
        super(new RfcLDAPMessage(new ASN1Sequence()));
        this.processmessage(byArray);
    }

    private void processmessage(byte[] byArray) throws IOException {
        LBERDecoder lBERDecoder = new LBERDecoder();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
        this.eventtype = ((ASN1Integer)aSN1Sequence.get(0)).intValue();
        this.eventResult = ((ASN1Integer)aSN1Sequence.get(1)).intValue();
        if (aSN1Sequence.size() > 2) {
            ASN1Tagged aSN1Tagged = (ASN1Tagged)aSN1Sequence.get(2);
            switch (aSN1Tagged.getIdentifier().getTag()) {
                case 1: {
                    this.responsedata = new EntryEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 2: {
                    this.responsedata = new ValueEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 16: {
                    this.responsedata = new DebugEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 3: {
                    this.responsedata = new GeneralDSEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 4: {
                    this.responsedata = null;
                    break;
                }
                case 5: {
                    this.responsedata = new BinderyObjectEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 6: {
                    this.responsedata = new SecurityEquivalenceEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 7: {
                    this.responsedata = new ModuleStateEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 8: {
                    this.responsedata = new NetworkAddressEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 9: {
                    this.responsedata = new ConnectionStateEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 12: {
                    this.responsedata = new ChangeAddressEventData(aSN1Tagged.taggedValue());
                    break;
                }
                case 14: {
                    this.responsedata = null;
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        } else {
            this.responsedata = null;
        }
    }

    public int getEventResult() {
        return this.eventResult;
    }

    public int getEventtype() {
        return this.eventtype;
    }

    public EventResponseData getResponsedata() {
        return this.responsedata;
    }

    public String toString() {
        return "[EdirEventIntermediateResponse(" + this.getMessageID() + "): " + "EventType=" + this.getEventtype() + " ResultCode=" + this.getEventResult() + " ResponseData=" + this.getResponsedata() + "]";
    }
}

