/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimezoneHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TimezoneHelper.class);

    private static SimpleDateFormat getFormatter(ZoneId zoneId) {
        LOG.debug("getFormatter zoneId= {}", (Object)zoneId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (zoneId != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(zoneId));
        }
        return sdf;
    }

    private static String getDay(Date date, ZoneId zoneId) {
        LOG.debug("getDay date={}, zoneId={}", (Object)date, (Object)zoneId);
        return TimezoneHelper.getFormatter(zoneId).format(date);
    }

    private static Date rezoneDate(Date date, ZoneId zoneId) throws ParseException {
        LOG.debug("rezoneDate date={}, zoneId={}", (Object)date, (Object)zoneId);
        String dayString = TimezoneHelper.getDay(date, ZoneId.systemDefault());
        Date rezonedDate = TimezoneHelper.getFormatter(zoneId).parse(dayString);
        LOG.debug("rezoneDate dayString={}, rezonedDate={}", (Object)dayString, (Object)rezonedDate);
        return rezonedDate;
    }

    public static long getRezonedEpoch(Date incomingDate, ZoneId zoneId) throws ParseException {
        LOG.debug("getRezonedEpoch incomingDate={}, zoneId={}", (Object)incomingDate, (Object)zoneId);
        return TimezoneHelper.rezoneDate(incomingDate, zoneId).getTime();
    }

    public static String formatDate(Date date, ZoneId zoneId, String pattern) throws ParseException {
        Date rezoned = TimezoneHelper.rezoneDate(date, zoneId);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone(zoneId));
        return format.format(rezoned);
    }

    public static String now(ZoneId zoneId, String pattern) throws ParseException {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone(zoneId));
        return format.format(now);
    }

    public static String getUtcOffset(ZoneId zoneId, Date referenceDate) {
        if (zoneId == null || referenceDate == null) {
            return "";
        }
        ZoneOffset zoneOffset = referenceDate.toInstant().atZone(zoneId).getOffset();
        String zoneOffsetString = zoneOffset.toString();
        String utcOffset = String.format("UTC%s", zoneOffsetString.equals("Z") ? "+00:00" : zoneOffsetString);
        return utcOffset;
    }
}

