/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.cms;

import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Set;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.BERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.opennms.shaded.org.bouncycastle.asn1.cms.OriginatorInfo;

public class AuthEnvelopedData
extends ASN1Encodable {
    private DERInteger version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo authEncryptedContentInfo;
    private ASN1Set authAttrs;
    private ASN1OctetString mac;
    private ASN1Set unauthAttrs;

    public AuthEnvelopedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        this.version = new DERInteger(0);
        this.originatorInfo = originatorInfo;
        this.recipientInfos = aSN1Set;
        this.authEncryptedContentInfo = encryptedContentInfo;
        this.authAttrs = aSN1Set2;
        this.mac = aSN1OctetString;
        this.unauthAttrs = aSN1Set3;
    }

    public AuthEnvelopedData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        DERObject dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
        this.version = (DERInteger)dERObject;
        dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
        if (dERObject instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)dERObject, false);
            dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
        }
        this.recipientInfos = ASN1Set.getInstance(dERObject);
        dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
        this.authEncryptedContentInfo = EncryptedContentInfo.getInstance(dERObject);
        if ((dERObject = aSN1Sequence.getObjectAt(n++).getDERObject()) instanceof ASN1TaggedObject) {
            this.authAttrs = ASN1Set.getInstance((ASN1TaggedObject)dERObject, false);
            dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
        }
        this.mac = ASN1OctetString.getInstance(dERObject);
        if (aSN1Sequence.size() > n) {
            dERObject = aSN1Sequence.getObjectAt(n++).getDERObject();
            this.unauthAttrs = ASN1Set.getInstance((ASN1TaggedObject)dERObject, false);
        }
    }

    public static AuthEnvelopedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AuthEnvelopedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthEnvelopedData getInstance(Object object) {
        if (object == null || object instanceof AuthEnvelopedData) {
            return (AuthEnvelopedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthEnvelopedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid AuthEnvelopedData: " + object.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getAuthEncryptedContentInfo() {
        return this.authEncryptedContentInfo;
    }

    public ASN1Set getAuthAttrs() {
        return this.authAttrs;
    }

    public ASN1OctetString getMac() {
        return this.mac;
    }

    public ASN1Set getUnauthAttrs() {
        return this.unauthAttrs;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        if (this.originatorInfo != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.originatorInfo));
        }
        aSN1EncodableVector.add(this.recipientInfos);
        aSN1EncodableVector.add(this.authEncryptedContentInfo);
        if (this.authAttrs != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.authAttrs));
        }
        aSN1EncodableVector.add(this.mac);
        if (this.unauthAttrs != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.unauthAttrs));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

